/*
 * Decompiled with CFR 0.152.
 */
package com.arxanfintech.common.rest;

import com.arxanfintech.common.rest.Request;
import com.arxanfintech.common.structs.Headers;
import com.arxanfintech.common.util.Utils;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.request.HttpRequestWithBody;
import java.io.File;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;

public class Api {
    public CloseableHttpClient httpclient;

    public CloseableHttpClient NewHttpClient() throws Exception {
        if (this.httpclient == null) {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext);
            CloseableHttpClient closeableHttpClient = HttpClients.custom().setSSLSocketFactory(sslsf).build();
        }
        return this.httpclient;
    }

    public String DoGet(Request request) throws Exception {
        try {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext);
            CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory(sslsf).build();
            Unirest.setHttpClient(httpclient);
            Map<String, String> mapHeader = Utils.JsonToMap(request.header);
            mapHeader.put(Headers.APIKeyHeader, request.client.GetApiKey());
            if (request.client.GetRouteTag() != "") {
                mapHeader.put(Headers.FabioRouteTagHeader, request.client.GetRouteTag());
                mapHeader.put(Headers.RouteTagHeader, request.client.GetRouteTag());
            }
            HttpResponse<String> res = Unirest.get(request.url).headers((Map)mapHeader).asString();
            String respData = res.getBody();
            System.out.println("Got remote cipher response: " + respData);
            String oriData = "";
            oriData = request.client.GetEnableCrypto() != false ? request.crypto.decryptAndVerify(respData.getBytes()) : respData;
            return oriData;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public String DoPost(Request request) {
        try {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext);
            CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory(sslsf).build();
            Unirest.setHttpClient(httpclient);
            String buf = "";
            buf = request.client.GetEnableCrypto() != false ? request.crypto.signAndEncrypt(request.body.toString().getBytes()) : request.body.toString();
            Map<String, String> mapHeader = Utils.JsonToMap(request.header);
            mapHeader.put(Headers.APIKeyHeader, request.client.GetApiKey());
            if (request.client.GetRouteTag() != "") {
                mapHeader.put(Headers.FabioRouteTagHeader, request.client.GetRouteTag());
                mapHeader.put(Headers.RouteTagHeader, request.client.GetRouteTag());
            }
            System.out.println("after sign and encrypt : " + buf);
            HttpResponse<String> res = ((HttpRequestWithBody)Unirest.post(request.url).headers((Map)mapHeader)).body(buf).asString();
            String respData = res.getBody();
            System.out.println("Got remote cipher response: " + respData);
            String oriData = "";
            oriData = request.client.GetEnableCrypto() != false ? request.crypto.decryptAndVerify(respData.getBytes()) : respData;
            return oriData;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return "";
        }
    }

    public String DoPut(Request request) {
        try {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext);
            CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory(sslsf).build();
            Unirest.setHttpClient(httpclient);
            String buf = "";
            buf = request.client.GetEnableCrypto() != false ? request.crypto.signAndEncrypt(request.body.toString().getBytes()) : request.body.toString();
            Map<String, String> mapHeader = Utils.JsonToMap(request.header);
            mapHeader.put(Headers.APIKeyHeader, request.client.GetApiKey());
            if (request.client.GetRouteTag() != "") {
                mapHeader.put(Headers.FabioRouteTagHeader, request.client.GetRouteTag());
                mapHeader.put(Headers.RouteTagHeader, request.client.GetRouteTag());
            }
            HttpResponse<String> res = ((HttpRequestWithBody)Unirest.put(request.url).headers((Map)mapHeader)).body(buf).asString();
            String respData = res.getBody();
            System.out.println("Got remote cipher response: " + respData);
            String oriData = "";
            oriData = request.client.GetEnableCrypto() != false ? request.crypto.decryptAndVerify(respData.getBytes()) : respData;
            return oriData;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return "";
        }
    }

    public String DoUploadFile(Request request, String filename, String poeid, Boolean readonly) {
        try {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext);
            CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory(sslsf).build();
            Unirest.setHttpClient(httpclient);
            String buf = "";
            buf = request.client.GetEnableCrypto() != false ? request.crypto.signAndEncrypt(request.body.toString().getBytes()) : request.body.toString();
            Map<String, String> mapHeader = Utils.JsonToMap(request.header);
            mapHeader.put(Headers.APIKeyHeader, request.client.GetApiKey());
            if (request.client.GetRouteTag() != "") {
                mapHeader.put(Headers.FabioRouteTagHeader, request.client.GetRouteTag());
                mapHeader.put(Headers.RouteTagHeader, request.client.GetRouteTag());
            }
            HttpResponse<String> res = ((HttpRequestWithBody)Unirest.post(request.url).headers((Map)mapHeader)).field("poe_id", poeid).field("read_only", readonly).field("poe_file", filename).field("file", new File(filename)).asString();
            String respData = res.getBody();
            System.out.println("Got remote cipher response: " + respData);
            String oriData = "";
            oriData = request.client.GetEnableCrypto() != false ? request.crypto.decryptAndVerify(respData.getBytes()) : respData;
            return oriData;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return "";
        }
    }
}

