/*
 * Decompiled with CFR 0.152.
 */
package com.arxanfintech.common.util;

import com.arxanfintech.common.crypto.Hash;
import java.math.BigInteger;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class ByteUtils {
    private static final char[] b58;
    private static final int[] r58;

    public static String toBase58(byte[] b) {
        int lz;
        if (b.length == 0) {
            return "";
        }
        for (lz = 0; lz < b.length && b[lz] == 0; ++lz) {
        }
        StringBuilder s = new StringBuilder();
        BigInteger n = new BigInteger(1, b);
        while (n.compareTo(BigInteger.ZERO) > 0) {
            BigInteger[] r = n.divideAndRemainder(BigInteger.valueOf(58L));
            n = r[0];
            char digit = b58[r[1].intValue()];
            s.append(digit);
        }
        while (lz > 0) {
            --lz;
            s.append("1");
        }
        return s.reverse().toString();
    }

    public static String toBase58WithChecksum(byte[] b) {
        byte[] cs = Hash.hash(b);
        byte[] extended = new byte[b.length + 4];
        System.arraycopy(b, 0, extended, 0, b.length);
        System.arraycopy(cs, 0, extended, b.length, 4);
        return ByteUtils.toBase58(extended);
    }

    public static byte[] reverse(byte[] data) {
        int i = 0;
        int j = data.length - 1;
        while (i < data.length / 2) {
            int n = i;
            data[n] = (byte)(data[n] ^ data[j]);
            int n2 = j;
            data[n2] = (byte)(data[n2] ^ data[i]);
            int n3 = i++;
            data[n3] = (byte)(data[n3] ^ data[j]);
            --j;
        }
        return data;
    }

    public static String toHex(byte[] data) {
        return new String(Hex.encodeHex(data));
    }

    public static byte[] fromHex(String hex) {
        try {
            return Hex.decodeHex(hex.toCharArray());
        }
        catch (DecoderException e) {
            return null;
        }
    }

    static {
        int i;
        b58 = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();
        r58 = new int[256];
        for (i = 0; i < 256; ++i) {
            ByteUtils.r58[i] = -1;
        }
        for (i = 0; i < b58.length; ++i) {
            ByteUtils.r58[ByteUtils.b58[i]] = i;
        }
    }
}

