/*
 * Decompiled with CFR 0.152.
 */
package com.arthenica.smartexception.java;

import com.arthenica.smartexception.AbstractExceptions;
import com.arthenica.smartexception.PackageLoader;
import com.arthenica.smartexception.StackTraceElementSerializer;
import com.arthenica.smartexception.java.Exceptions;

public class JavaStackTraceElementSerializer
implements StackTraceElementSerializer {
    public String toString(StackTraceElement stackTraceElement, boolean printModuleName, boolean printPackageInformation) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(stackTraceElement.getClassName());
        stringBuilder.append(".");
        stringBuilder.append(stackTraceElement.getMethodName());
        if (stackTraceElement.isNativeMethod()) {
            stringBuilder.append(this.getNativeMethodDefinition());
        } else if (stackTraceElement.getFileName() != null && stackTraceElement.getFileName().length() > 0) {
            stringBuilder.append("(");
            stringBuilder.append(stackTraceElement.getFileName());
            if (stackTraceElement.getLineNumber() >= 0) {
                stringBuilder.append(":");
                stringBuilder.append(stackTraceElement.getLineNumber());
            }
            stringBuilder.append(")");
        } else {
            stringBuilder.append(this.getUnknownSourceDefinition());
        }
        if (printPackageInformation) {
            stringBuilder.append(this.getPackageInformation(stackTraceElement));
        }
        return stringBuilder.toString();
    }

    public String getPackageInformation(StackTraceElement stackTraceElement) {
        StringBuilder stringBuilder = new StringBuilder();
        String className = stackTraceElement.getClassName();
        Class loadedClass = Exceptions.classLoader.loadClass(className);
        if (loadedClass != null) {
            String libraryName = AbstractExceptions.libraryName((Class)loadedClass);
            String version = AbstractExceptions.version((PackageLoader)Exceptions.packageLoader, (Class)loadedClass, (String)AbstractExceptions.packageName((String)className));
            stringBuilder.append(AbstractExceptions.packageInformation((String)libraryName, (String)version));
        }
        return stringBuilder.toString();
    }

    public String getModuleName(StackTraceElement stackTraceElement) {
        return "";
    }

    public String getNativeMethodDefinition() {
        return "(Native Method)";
    }

    public String getUnknownSourceDefinition() {
        return "(Unknown Source)";
    }
}

