/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.velocypack;

import com.arangodb.entity.BaseDocument;
import com.arangodb.entity.BaseEdgeDocument;
import com.arangodb.entity.CollectionStatus;
import com.arangodb.entity.CollectionType;
import com.arangodb.entity.License;
import com.arangodb.entity.LogLevel;
import com.arangodb.entity.MinReplicationFactor;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.QueryExecutionState;
import com.arangodb.entity.ReplicationFactor;
import com.arangodb.entity.ViewEntity;
import com.arangodb.entity.ViewType;
import com.arangodb.entity.arangosearch.ArangoSearchProperties;
import com.arangodb.entity.arangosearch.ArangoSearchPropertiesEntity;
import com.arangodb.entity.arangosearch.CollectionLink;
import com.arangodb.entity.arangosearch.ConsolidationPolicy;
import com.arangodb.entity.arangosearch.ConsolidationType;
import com.arangodb.entity.arangosearch.FieldLink;
import com.arangodb.entity.arangosearch.PrimarySort;
import com.arangodb.entity.arangosearch.StoreValuesType;
import com.arangodb.velocypack.VPackDeserializer;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocystream.Response;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VPackDeserializers {
    private static final Logger LOGGER = LoggerFactory.getLogger(VPackDeserializers.class);
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final VPackDeserializer<Response> RESPONSE = (parent, vpack, context) -> {
        Response response = new Response();
        response.setVersion(vpack.get(0).getAsInt());
        response.setType(vpack.get(1).getAsInt());
        response.setResponseCode(vpack.get(2).getAsInt());
        if (vpack.size() > 3) {
            response.setMeta((Map)context.deserialize(vpack.get(3), Map.class));
        }
        return response;
    };
    public static final VPackDeserializer<CollectionType> COLLECTION_TYPE = (parent, vpack, context) -> CollectionType.fromType(vpack.getAsInt());
    public static final VPackDeserializer<CollectionStatus> COLLECTION_STATUS = (parent, vpack, context) -> CollectionStatus.fromStatus(vpack.getAsInt());
    public static final VPackDeserializer<BaseDocument> BASE_DOCUMENT = (parent, vpack, context) -> new BaseDocument((Map)context.deserialize(vpack, Map.class));
    public static final VPackDeserializer<BaseEdgeDocument> BASE_EDGE_DOCUMENT = (parent, vpack, context) -> new BaseEdgeDocument((Map)context.deserialize(vpack, Map.class));
    public static final VPackDeserializer<Date> DATE_STRING = (parent, vpack, context) -> {
        try {
            return new SimpleDateFormat(DATE_TIME_FORMAT).parse(vpack.getAsString());
        }
        catch (ParseException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("got ParseException for date string: " + vpack.getAsString());
            }
            return null;
        }
    };
    public static final VPackDeserializer<LogLevel> LOG_LEVEL = (parent, vpack, context) -> LogLevel.fromLevel(vpack.getAsInt());
    public static final VPackDeserializer<License> LICENSE = (parent, vpack, context) -> License.valueOf(vpack.getAsString().toUpperCase());
    public static final VPackDeserializer<Permissions> PERMISSIONS = (parent, vpack, context) -> Permissions.valueOf(vpack.getAsString().toUpperCase());
    public static final VPackDeserializer<QueryExecutionState> QUERY_EXECUTION_STATE = (parent, vpack, context) -> QueryExecutionState.valueOf(vpack.getAsString().toUpperCase().replaceAll(" ", "_"));
    public static final VPackDeserializer<ReplicationFactor> REPLICATION_FACTOR = (parent, vpack, context) -> {
        ReplicationFactor replicationFactor = new ReplicationFactor();
        if (vpack.isString() && vpack.getAsString().equals("satellite")) {
            replicationFactor.setSatellite(true);
        } else {
            replicationFactor.setReplicationFactor(vpack.getAsInt());
        }
        return replicationFactor;
    };
    public static final VPackDeserializer<MinReplicationFactor> MIN_REPLICATION_FACTOR = (parent, vpack, context) -> {
        MinReplicationFactor minReplicationFactor = new MinReplicationFactor();
        minReplicationFactor.setMinReplicationFactor(vpack.getAsInt());
        return minReplicationFactor;
    };
    public static final VPackDeserializer<ViewType> VIEW_TYPE = (parent, vpack, context) -> "arangosearch".equals(vpack.getAsString()) ? ViewType.ARANGO_SEARCH : ViewType.valueOf(vpack.getAsString().toUpperCase());
    public static final VPackDeserializer<ArangoSearchProperties> ARANGO_SEARCH_PROPERTIES = (parent, vpack, context) -> {
        VPackSlice primarySorts;
        VPackSlice links;
        VPackSlice consolidationPolicy;
        VPackSlice cleanupIntervalStep;
        VPackSlice commitIntervalMsec;
        ArangoSearchProperties properties = new ArangoSearchProperties();
        VPackSlice consolidationIntervalMsec = vpack.get("consolidationIntervalMsec");
        if (consolidationIntervalMsec.isInteger()) {
            properties.setConsolidationIntervalMsec(consolidationIntervalMsec.getAsLong());
        }
        if ((commitIntervalMsec = vpack.get("commitIntervalMsec")).isInteger()) {
            properties.setCommitIntervalMsec(commitIntervalMsec.getAsLong());
        }
        if ((cleanupIntervalStep = vpack.get("cleanupIntervalStep")).isInteger()) {
            properties.setCleanupIntervalStep(cleanupIntervalStep.getAsLong());
        }
        if ((consolidationPolicy = vpack.get("consolidationPolicy")).isObject()) {
            properties.setConsolidationPolicy((ConsolidationPolicy)context.deserialize(consolidationPolicy, ConsolidationPolicy.class));
        }
        if ((links = vpack.get("links")).isObject()) {
            Iterator collectionIterator = links.objectIterator();
            while (collectionIterator.hasNext()) {
                VPackSlice fields;
                VPackSlice storeValues;
                VPackSlice trackListPositions;
                VPackSlice includeAllFields;
                Map.Entry entry = (Map.Entry)collectionIterator.next();
                VPackSlice value = (VPackSlice)entry.getValue();
                CollectionLink link = CollectionLink.on((String)entry.getKey());
                VPackSlice analyzers = value.get("analyzers");
                if (analyzers.isArray()) {
                    Iterator analyzerIterator = analyzers.arrayIterator();
                    while (analyzerIterator.hasNext()) {
                        link.analyzers(((VPackSlice)analyzerIterator.next()).getAsString());
                    }
                }
                if ((includeAllFields = value.get("includeAllFields")).isBoolean()) {
                    link.includeAllFields(includeAllFields.getAsBoolean());
                }
                if ((trackListPositions = value.get("trackListPositions")).isBoolean()) {
                    link.trackListPositions(trackListPositions.getAsBoolean());
                }
                if ((storeValues = value.get("storeValues")).isString()) {
                    link.storeValues(StoreValuesType.valueOf(storeValues.getAsString().toUpperCase()));
                }
                if ((fields = value.get("fields")).isObject()) {
                    Iterator fieldsIterator = fields.objectIterator();
                    while (fieldsIterator.hasNext()) {
                        link.fields(VPackDeserializers.deserializeField((Map.Entry)fieldsIterator.next()));
                    }
                }
                properties.addLink(link);
            }
        }
        if ((primarySorts = vpack.get("primarySort")).isArray()) {
            Iterator primarySortsIterator = primarySorts.arrayIterator();
            while (primarySortsIterator.hasNext()) {
                VPackSlice entry = (VPackSlice)primarySortsIterator.next();
                if (!entry.isObject() || !entry.get("field").isString() || !entry.get("asc").isBoolean()) continue;
                PrimarySort primarySort = PrimarySort.on(entry.get("field").getAsString());
                primarySort.ascending(entry.get("asc").getAsBoolean());
                properties.addPrimarySort(primarySort);
            }
        }
        return properties;
    };
    public static final VPackDeserializer<ArangoSearchPropertiesEntity> ARANGO_SEARCH_PROPERTIES_ENTITY = (parent, vpack, context) -> {
        ViewEntity entity = (ViewEntity)context.deserialize(vpack, ViewEntity.class);
        ArangoSearchProperties properties = (ArangoSearchProperties)context.deserialize(vpack, ArangoSearchProperties.class);
        return new ArangoSearchPropertiesEntity(entity.getId(), entity.getName(), entity.getType(), properties);
    };
    public static final VPackDeserializer<ConsolidationPolicy> CONSOLIDATE = (parent, vpack, context) -> {
        VPackSlice type = vpack.get("type");
        if (type.isString()) {
            VPackSlice segmentThreshold;
            ConsolidationPolicy consolidate = ConsolidationPolicy.of(ConsolidationType.valueOf(type.getAsString().toUpperCase()));
            VPackSlice threshold = vpack.get("threshold");
            if (threshold.isNumber()) {
                consolidate.threshold(threshold.getAsDouble());
            }
            if ((segmentThreshold = vpack.get("segmentThreshold")).isInteger()) {
                consolidate.segmentThreshold(segmentThreshold.getAsLong());
            }
            return consolidate;
        }
        return null;
    };

    protected static FieldLink deserializeField(Map.Entry<String, VPackSlice> field) {
        VPackSlice fields;
        VPackSlice storeValues;
        VPackSlice trackListPositions;
        VPackSlice includeAllFields;
        VPackSlice value = field.getValue();
        FieldLink link = FieldLink.on(field.getKey());
        VPackSlice analyzers = value.get("analyzers");
        if (analyzers.isArray()) {
            Iterator analyzerIterator = analyzers.arrayIterator();
            while (analyzerIterator.hasNext()) {
                link.analyzers(((VPackSlice)analyzerIterator.next()).getAsString());
            }
        }
        if ((includeAllFields = value.get("includeAllFields")).isBoolean()) {
            link.includeAllFields(includeAllFields.getAsBoolean());
        }
        if ((trackListPositions = value.get("trackListPositions")).isBoolean()) {
            link.trackListPositions(trackListPositions.getAsBoolean());
        }
        if ((storeValues = value.get("storeValues")).isString()) {
            link.storeValues(StoreValuesType.valueOf(storeValues.getAsString().toUpperCase()));
        }
        if ((fields = value.get("fields")).isObject()) {
            Iterator fieldsIterator = fields.objectIterator();
            while (fieldsIterator.hasNext()) {
                link.fields(VPackDeserializers.deserializeField((Map.Entry)fieldsIterator.next()));
            }
        }
        return link;
    }
}

