/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.cursor;

import com.arangodb.ArangoIterable;
import com.arangodb.ArangoIterator;
import com.arangodb.Consumer;
import com.arangodb.Predicate;
import com.arangodb.internal.cursor.AbstractArangoIterable;
import com.arangodb.internal.cursor.ArangoFilterIterator;

public class ArangoFilterIterable<T>
extends AbstractArangoIterable<T>
implements ArangoIterable<T> {
    private final ArangoIterable<T> iterable;
    private final Predicate<? super T> predicate;

    protected ArangoFilterIterable(ArangoIterable<T> iterable, Predicate<? super T> predicate) {
        this.iterable = iterable;
        this.predicate = predicate;
    }

    @Override
    public ArangoIterator<T> iterator() {
        return new ArangoFilterIterator<T>(this.iterable.iterator(), this.predicate);
    }

    @Override
    public void foreach(Consumer<? super T> action) {
        for (Object t : this.iterable) {
            if (!this.predicate.test(t)) continue;
            action.accept(t);
        }
    }
}

