/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoEdgeCollection;
import com.arangodb.entity.EdgeEntity;
import com.arangodb.entity.EdgeUpdateEntity;
import com.arangodb.internal.ArangoDBImpl;
import com.arangodb.internal.ArangoDatabaseImpl;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.ArangoGraphImpl;
import com.arangodb.internal.InternalArangoEdgeCollection;
import com.arangodb.model.EdgeCreateOptions;
import com.arangodb.model.EdgeDeleteOptions;
import com.arangodb.model.EdgeReplaceOptions;
import com.arangodb.model.EdgeUpdateOptions;
import com.arangodb.model.GraphDocumentReadOptions;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArangoEdgeCollectionImpl
extends InternalArangoEdgeCollection<ArangoDBImpl, ArangoDatabaseImpl, ArangoGraphImpl, ArangoExecutorSync>
implements ArangoEdgeCollection {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArangoEdgeCollectionImpl.class);

    protected ArangoEdgeCollectionImpl(ArangoGraphImpl graph, String name) {
        super(graph, name);
    }

    @Override
    public <T> EdgeEntity insertEdge(T value) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.insertEdgeRequest(value, new EdgeCreateOptions()), this.insertEdgeResponseDeserializer(value));
    }

    @Override
    public <T> EdgeEntity insertEdge(T value, EdgeCreateOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.insertEdgeRequest(value, options), this.insertEdgeResponseDeserializer(value));
    }

    @Override
    public <T> T getEdge(String key, Class<T> type) throws ArangoDBException {
        try {
            return ((ArangoExecutorSync)this.executor).execute(this.getEdgeRequest(key, new GraphDocumentReadOptions()), this.getEdgeResponseDeserializer(type));
        }
        catch (ArangoDBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public <T> T getEdge(String key, Class<T> type, GraphDocumentReadOptions options) throws ArangoDBException {
        try {
            return ((ArangoExecutorSync)this.executor).execute(this.getEdgeRequest(key, options), this.getEdgeResponseDeserializer(type));
        }
        catch (ArangoDBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public <T> EdgeUpdateEntity replaceEdge(String key, T value) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.replaceEdgeRequest(key, value, new EdgeReplaceOptions()), this.replaceEdgeResponseDeserializer(value));
    }

    @Override
    public <T> EdgeUpdateEntity replaceEdge(String key, T value, EdgeReplaceOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.replaceEdgeRequest(key, value, options), this.replaceEdgeResponseDeserializer(value));
    }

    @Override
    public <T> EdgeUpdateEntity updateEdge(String key, T value) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.updateEdgeRequest(key, value, new EdgeUpdateOptions()), this.updateEdgeResponseDeserializer(value));
    }

    @Override
    public <T> EdgeUpdateEntity updateEdge(String key, T value, EdgeUpdateOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.updateEdgeRequest(key, value, options), this.updateEdgeResponseDeserializer(value));
    }

    @Override
    public void deleteEdge(String key) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.deleteEdgeRequest(key, new EdgeDeleteOptions()), (Type)((Object)Void.class));
    }

    @Override
    public void deleteEdge(String key, EdgeDeleteOptions options) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.deleteEdgeRequest(key, options), (Type)((Object)Void.class));
    }
}

