/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.velocystream.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.internal.velocystream.internal.Message;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageStore.class);
    private final Map<Long, FutureTask<Message>> task = new ConcurrentHashMap<Long, FutureTask<Message>>();
    private final Map<Long, Message> response = new ConcurrentHashMap<Long, Message>();
    private final Map<Long, Exception> error = new ConcurrentHashMap<Long, Exception>();

    public void storeMessage(long messageId, FutureTask<Message> future) {
        this.task.put(messageId, future);
    }

    public void consume(Message message) {
        FutureTask<Message> future = this.task.remove(message.getId());
        if (future != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Received Message (id=%s, head=%s, body=%s)", message.getId(), message.getHead(), message.getBody() != null ? message.getBody() : "{}"));
            }
            this.response.put(message.getId(), message);
            future.run();
        }
    }

    public Message get(long messageId) throws ArangoDBException {
        Exception e;
        Message result = this.response.remove(messageId);
        if (result == null && (e = this.error.remove(messageId)) != null) {
            throw new ArangoDBException(e);
        }
        return result;
    }

    public void cancel(long messageId) {
        FutureTask<Message> future = this.task.remove(messageId);
        if (future != null) {
            LOGGER.error(String.format("Cancel Message unexpected (id=%s).", messageId));
            future.cancel(true);
        }
    }

    public synchronized void clear(Exception e) {
        if (!this.task.isEmpty()) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        for (Map.Entry<Long, FutureTask<Message>> entry : this.task.entrySet()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Exceptionally complete Message (id=%s).", entry.getKey()));
            }
            this.error.put(entry.getKey(), e);
            entry.getValue().run();
        }
        this.task.clear();
    }

    public synchronized void clear() {
        for (Map.Entry<Long, FutureTask<Message>> entry : this.task.entrySet()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Cancel Message (id=%s).", entry.getKey()));
            }
            entry.getValue().cancel(true);
        }
        this.task.clear();
    }

    public boolean isEmpty() {
        return this.task.isEmpty();
    }
}

