/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.net;

import com.arangodb.internal.net.AccessType;
import com.arangodb.internal.net.Host;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.net.HostResolver;
import com.arangodb.internal.net.HostSet;
import java.util.ArrayList;
import java.util.Collections;

public class RandomHostHandler
implements HostHandler {
    private final HostResolver resolver;
    private final HostHandler fallback;
    private Host current;

    public RandomHostHandler(HostResolver resolver, HostHandler fallback) {
        this.resolver = resolver;
        this.fallback = fallback;
        this.current = this.getRandomHost(true, false);
    }

    @Override
    public Host get(HostHandle hostHandle, AccessType accessType) {
        if (this.current == null) {
            this.current = this.getRandomHost(false, true);
        }
        return this.current;
    }

    @Override
    public void success() {
        this.fallback.success();
    }

    @Override
    public void fail() {
        this.fallback.fail();
        this.current = this.fallback.get(null, null);
    }

    private Host getRandomHost(boolean initial, boolean closeConnections) {
        ArrayList<Host> hosts = new ArrayList<Host>(this.resolver.resolve(initial, closeConnections).getHostsList());
        Collections.shuffle(hosts);
        return hosts.get(0);
    }

    @Override
    public void reset() {
        this.fallback.reset();
    }

    @Override
    public void confirm() {
    }

    @Override
    public void close() {
        HostSet hosts = this.resolver.resolve(false, false);
        hosts.close();
    }

    @Override
    public void closeCurrentOnError() {
        this.current.closeOnError();
    }
}

