/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.velocystream.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.internal.net.HostDescription;
import com.arangodb.internal.velocystream.internal.Chunk;
import com.arangodb.internal.velocystream.internal.Message;
import com.arangodb.internal.velocystream.internal.MessageStore;
import com.arangodb.internal.velocystream.internal.VstConnection;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;

public class VstConnectionSync
extends VstConnection {
    private VstConnectionSync(HostDescription host, Integer timeout, Long ttl, Boolean useSsl, SSLContext sslContext, MessageStore messageStore) {
        super(host, timeout, ttl, useSsl, sslContext, messageStore);
    }

    public Message write(final Message message, Collection<Chunk> chunks) throws ArangoDBException {
        FutureTask<Message> task = new FutureTask<Message>(new Callable<Message>(){

            @Override
            public Message call() throws Exception {
                return VstConnectionSync.this.messageStore.get(message.getId());
            }
        });
        this.messageStore.storeMessage(message.getId(), task);
        super.writeIntern(message, chunks);
        try {
            return this.timeout == null || (long)this.timeout.intValue() == 0L ? task.get() : task.get(this.timeout.intValue(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new ArangoDBException(e);
        }
    }

    public static class Builder {
        private HostDescription host;
        private MessageStore messageStore;
        private Integer timeout;
        private Long ttl;
        private Boolean useSsl;
        private SSLContext sslContext;

        public Builder host(HostDescription host) {
            this.host = host;
            return this;
        }

        public Builder messageStore(MessageStore messageStore) {
            this.messageStore = messageStore;
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder useSsl(Boolean useSsl) {
            this.useSsl = useSsl;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public VstConnectionSync build() {
            return new VstConnectionSync(this.host, this.timeout, this.ttl, this.useSsl, this.sslContext, this.messageStore);
        }
    }
}

