/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.velocypack;

import com.arangodb.entity.BaseDocument;
import com.arangodb.entity.BaseEdgeDocument;
import com.arangodb.entity.CollectionType;
import com.arangodb.entity.DocumentField;
import com.arangodb.entity.LogLevel;
import com.arangodb.entity.MinReplicationFactor;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.ReplicationFactor;
import com.arangodb.entity.ViewType;
import com.arangodb.entity.arangosearch.ArangoSearchProperties;
import com.arangodb.entity.arangosearch.CollectionLink;
import com.arangodb.entity.arangosearch.ConsolidationType;
import com.arangodb.entity.arangosearch.FieldLink;
import com.arangodb.entity.arangosearch.PrimarySort;
import com.arangodb.entity.arangosearch.StoreValuesType;
import com.arangodb.internal.velocystream.internal.AuthenticationRequest;
import com.arangodb.model.TraversalOptions;
import com.arangodb.model.arangosearch.ArangoSearchPropertiesOptions;
import com.arangodb.velocypack.VPackBuilder;
import com.arangodb.velocypack.VPackSerializationContext;
import com.arangodb.velocypack.VPackSerializer;
import com.arangodb.velocypack.ValueType;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocystream.Request;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class VPackSerializers {
    public static final VPackSerializer<Request> REQUEST = new VPackSerializer<Request>(){

        public void serialize(VPackBuilder builder, String attribute, Request value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, ValueType.ARRAY);
            builder.add(Integer.valueOf(value.getVersion()));
            builder.add(Integer.valueOf(value.getType()));
            builder.add(value.getDatabase());
            builder.add(Integer.valueOf(value.getRequestType().getType()));
            builder.add(value.getRequest());
            builder.add(ValueType.OBJECT);
            for (Map.Entry<String, String> entry : value.getQueryParam().entrySet()) {
                builder.add(entry.getKey(), entry.getValue());
            }
            builder.close();
            builder.add(ValueType.OBJECT);
            for (Map.Entry<String, String> entry : value.getHeaderParam().entrySet()) {
                builder.add(entry.getKey(), entry.getValue());
            }
            builder.close();
            builder.close();
        }
    };
    public static final VPackSerializer<AuthenticationRequest> AUTH_REQUEST = new VPackSerializer<AuthenticationRequest>(){

        public void serialize(VPackBuilder builder, String attribute, AuthenticationRequest value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, ValueType.ARRAY);
            builder.add(Integer.valueOf(value.getVersion()));
            builder.add(Integer.valueOf(value.getType()));
            builder.add(value.getEncryption());
            builder.add(value.getUser());
            builder.add(value.getPassword());
            builder.close();
        }
    };
    public static final VPackSerializer<CollectionType> COLLECTION_TYPE = new VPackSerializer<CollectionType>(){

        public void serialize(VPackBuilder builder, String attribute, CollectionType value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, Integer.valueOf(value.getType()));
        }
    };
    public static final VPackSerializer<BaseDocument> BASE_DOCUMENT = new VPackSerializer<BaseDocument>(){

        public void serialize(VPackBuilder builder, String attribute, BaseDocument value, VPackSerializationContext context) throws VPackException {
            HashMap<String, Object> doc = new HashMap<String, Object>();
            doc.putAll(value.getProperties());
            doc.put(DocumentField.Type.ID.getSerializeName(), value.getId());
            doc.put(DocumentField.Type.KEY.getSerializeName(), value.getKey());
            doc.put(DocumentField.Type.REV.getSerializeName(), value.getRevision());
            context.serialize(builder, attribute, doc);
        }
    };
    public static final VPackSerializer<BaseEdgeDocument> BASE_EDGE_DOCUMENT = new VPackSerializer<BaseEdgeDocument>(){

        public void serialize(VPackBuilder builder, String attribute, BaseEdgeDocument value, VPackSerializationContext context) throws VPackException {
            HashMap<String, Object> doc = new HashMap<String, Object>();
            doc.putAll(value.getProperties());
            doc.put(DocumentField.Type.ID.getSerializeName(), value.getId());
            doc.put(DocumentField.Type.KEY.getSerializeName(), value.getKey());
            doc.put(DocumentField.Type.REV.getSerializeName(), value.getRevision());
            doc.put(DocumentField.Type.FROM.getSerializeName(), value.getFrom());
            doc.put(DocumentField.Type.TO.getSerializeName(), value.getTo());
            context.serialize(builder, attribute, doc);
        }
    };
    public static final VPackSerializer<TraversalOptions.Order> TRAVERSAL_ORDER = new VPackSerializer<TraversalOptions.Order>(){

        public void serialize(VPackBuilder builder, String attribute, TraversalOptions.Order value, VPackSerializationContext context) throws VPackException {
            if (TraversalOptions.Order.preorder_expander == value) {
                builder.add(attribute, "preorder-expander");
            } else {
                builder.add(attribute, value.name());
            }
        }
    };
    public static final VPackSerializer<LogLevel> LOG_LEVEL = new VPackSerializer<LogLevel>(){

        public void serialize(VPackBuilder builder, String attribute, LogLevel value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, Integer.valueOf(value.getLevel()));
        }
    };
    public static final VPackSerializer<Permissions> PERMISSIONS = new VPackSerializer<Permissions>(){

        public void serialize(VPackBuilder builder, String attribute, Permissions value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, value.toString().toLowerCase());
        }
    };
    public static final VPackSerializer<ReplicationFactor> REPLICATION_FACTOR = new VPackSerializer<ReplicationFactor>(){

        public void serialize(VPackBuilder builder, String attribute, ReplicationFactor value, VPackSerializationContext context) throws VPackException {
            Boolean satellite = value.getSatellite();
            if (Boolean.TRUE == satellite) {
                builder.add(attribute, "satellite");
            } else if (value.getReplicationFactor() != null) {
                builder.add(attribute, value.getReplicationFactor());
            }
        }
    };
    public static final VPackSerializer<MinReplicationFactor> MIN_REPLICATION_FACTOR = new VPackSerializer<MinReplicationFactor>(){

        public void serialize(VPackBuilder builder, String attribute, MinReplicationFactor value, VPackSerializationContext context) throws VPackException {
            if (value.getMinReplicationFactor() != null) {
                builder.add(attribute, value.getMinReplicationFactor());
            }
        }
    };
    public static final VPackSerializer<ViewType> VIEW_TYPE = new VPackSerializer<ViewType>(){

        public void serialize(VPackBuilder builder, String attribute, ViewType value, VPackSerializationContext context) throws VPackException {
            String type = value == ViewType.ARANGO_SEARCH ? "arangosearch" : value.name().toLowerCase();
            builder.add(attribute, type);
        }
    };
    public static final VPackSerializer<ArangoSearchPropertiesOptions> ARANGO_SEARCH_PROPERTIES_OPTIONS = new VPackSerializer<ArangoSearchPropertiesOptions>(){

        public void serialize(VPackBuilder builder, String attribute, ArangoSearchPropertiesOptions value, VPackSerializationContext context) throws VPackException {
            builder.add(ValueType.OBJECT);
            context.serialize(builder, attribute, (Object)value.getProperties());
            builder.close();
        }
    };
    public static final VPackSerializer<ArangoSearchProperties> ARANGO_SEARCH_PROPERTIES = new VPackSerializer<ArangoSearchProperties>(){

        public void serialize(VPackBuilder builder, String attribute, ArangoSearchProperties value, VPackSerializationContext context) throws VPackException {
            Collection<PrimarySort> primarySorts;
            Long cleanupIntervalStep;
            Long commitIntervalMsec;
            Long consolidationIntervalMsec = value.getConsolidationIntervalMsec();
            if (consolidationIntervalMsec != null) {
                builder.add("consolidationIntervalMsec", consolidationIntervalMsec);
            }
            if ((commitIntervalMsec = value.getCommitIntervalMsec()) != null) {
                builder.add("commitIntervalMsec", commitIntervalMsec);
            }
            if ((cleanupIntervalStep = value.getCleanupIntervalStep()) != null) {
                builder.add("cleanupIntervalStep", cleanupIntervalStep);
            }
            context.serialize(builder, "consolidationPolicy", (Object)value.getConsolidationPolicy());
            Collection<CollectionLink> links = value.getLinks();
            if (!links.isEmpty()) {
                builder.add("links", ValueType.OBJECT);
                for (CollectionLink collectionLink : links) {
                    StoreValuesType storeValues;
                    Boolean trackListPositions;
                    Boolean includeAllFields;
                    builder.add(collectionLink.getName(), ValueType.OBJECT);
                    Collection<String> analyzers = collectionLink.getAnalyzers();
                    if (!analyzers.isEmpty()) {
                        builder.add("analyzers", ValueType.ARRAY);
                        for (String analyzer : analyzers) {
                            builder.add(analyzer);
                        }
                        builder.close();
                    }
                    if ((includeAllFields = collectionLink.getIncludeAllFields()) != null) {
                        builder.add("includeAllFields", includeAllFields);
                    }
                    if ((trackListPositions = collectionLink.getTrackListPositions()) != null) {
                        builder.add("trackListPositions", trackListPositions);
                    }
                    if ((storeValues = collectionLink.getStoreValues()) != null) {
                        builder.add("storeValues", storeValues.name().toLowerCase());
                    }
                    VPackSerializers.serializeFieldLinks(builder, collectionLink.getFields());
                    builder.close();
                }
                builder.close();
            }
            if (!(primarySorts = value.getPrimarySort()).isEmpty()) {
                builder.add("primarySort", ValueType.ARRAY);
                for (PrimarySort primarySort : primarySorts) {
                    builder.add(ValueType.OBJECT);
                    builder.add("field", primarySort.getFieldName());
                    builder.add("asc", primarySort.getAscending());
                    builder.close();
                }
                builder.close();
            }
        }
    };
    public static final VPackSerializer<ConsolidationType> CONSOLIDATE_TYPE = new VPackSerializer<ConsolidationType>(){

        public void serialize(VPackBuilder builder, String attribute, ConsolidationType value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, value.toString().toLowerCase());
        }
    };

    private static void serializeFieldLinks(VPackBuilder builder, Collection<FieldLink> links) {
        if (!links.isEmpty()) {
            builder.add("fields", ValueType.OBJECT);
            for (FieldLink fieldLink : links) {
                StoreValuesType storeValues;
                Boolean trackListPositions;
                Boolean includeAllFields;
                builder.add(fieldLink.getName(), ValueType.OBJECT);
                Collection<String> analyzers = fieldLink.getAnalyzers();
                if (!analyzers.isEmpty()) {
                    builder.add("analyzers", ValueType.ARRAY);
                    for (String analyzer : analyzers) {
                        builder.add(analyzer);
                    }
                    builder.close();
                }
                if ((includeAllFields = fieldLink.getIncludeAllFields()) != null) {
                    builder.add("includeAllFields", includeAllFields);
                }
                if ((trackListPositions = fieldLink.getTrackListPositions()) != null) {
                    builder.add("trackListPositions", trackListPositions);
                }
                if ((storeValues = fieldLink.getStoreValues()) != null) {
                    builder.add("storeValues", storeValues.name().toLowerCase());
                }
                VPackSerializers.serializeFieldLinks(builder, fieldLink.getFields());
                builder.close();
            }
            builder.close();
        }
    }
}

