/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.velocypack;

import com.arangodb.entity.BaseDocument;
import com.arangodb.entity.BaseEdgeDocument;
import com.arangodb.entity.CollectionStatus;
import com.arangodb.entity.CollectionType;
import com.arangodb.entity.License;
import com.arangodb.entity.LogLevel;
import com.arangodb.entity.MinReplicationFactor;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.QueryExecutionState;
import com.arangodb.entity.ReplicationFactor;
import com.arangodb.entity.ViewEntity;
import com.arangodb.entity.ViewType;
import com.arangodb.entity.arangosearch.ArangoSearchProperties;
import com.arangodb.entity.arangosearch.ArangoSearchPropertiesEntity;
import com.arangodb.entity.arangosearch.CollectionLink;
import com.arangodb.entity.arangosearch.ConsolidationPolicy;
import com.arangodb.entity.arangosearch.ConsolidationType;
import com.arangodb.entity.arangosearch.FieldLink;
import com.arangodb.entity.arangosearch.PrimarySort;
import com.arangodb.entity.arangosearch.StoreValuesType;
import com.arangodb.velocypack.VPackDeserializationContext;
import com.arangodb.velocypack.VPackDeserializer;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocystream.Response;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VPackDeserializers {
    private static final Logger LOGGER = LoggerFactory.getLogger(VPackDeserializers.class);
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final VPackDeserializer<Response> RESPONSE = new VPackDeserializer<Response>(){

        public Response deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            Response response = new Response();
            response.setVersion(vpack.get(0).getAsInt());
            response.setType(vpack.get(1).getAsInt());
            response.setResponseCode(vpack.get(2).getAsInt());
            if (vpack.size() > 3) {
                response.setMeta((Map)context.deserialize(vpack.get(3), Map.class));
            }
            return response;
        }
    };
    public static final VPackDeserializer<CollectionType> COLLECTION_TYPE = new VPackDeserializer<CollectionType>(){

        public CollectionType deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return CollectionType.fromType(vpack.getAsInt());
        }
    };
    public static final VPackDeserializer<CollectionStatus> COLLECTION_STATUS = new VPackDeserializer<CollectionStatus>(){

        public CollectionStatus deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return CollectionStatus.fromStatus(vpack.getAsInt());
        }
    };
    public static final VPackDeserializer<BaseDocument> BASE_DOCUMENT = new VPackDeserializer<BaseDocument>(){

        public BaseDocument deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return new BaseDocument((Map)context.deserialize(vpack, Map.class));
        }
    };
    public static final VPackDeserializer<BaseEdgeDocument> BASE_EDGE_DOCUMENT = new VPackDeserializer<BaseEdgeDocument>(){

        public BaseEdgeDocument deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return new BaseEdgeDocument((Map)context.deserialize(vpack, Map.class));
        }
    };
    public static final VPackDeserializer<Date> DATE_STRING = new VPackDeserializer<Date>(){

        public Date deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            try {
                return new SimpleDateFormat(VPackDeserializers.DATE_TIME_FORMAT).parse(vpack.getAsString());
            }
            catch (ParseException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("got ParseException for date string: " + vpack.getAsString());
                }
                return null;
            }
        }
    };
    public static final VPackDeserializer<LogLevel> LOG_LEVEL = new VPackDeserializer<LogLevel>(){

        public LogLevel deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return LogLevel.fromLevel(vpack.getAsInt());
        }
    };
    public static final VPackDeserializer<License> LICENSE = new VPackDeserializer<License>(){

        public License deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return License.valueOf(vpack.getAsString().toUpperCase());
        }
    };
    public static final VPackDeserializer<Permissions> PERMISSIONS = new VPackDeserializer<Permissions>(){

        public Permissions deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return Permissions.valueOf(vpack.getAsString().toUpperCase());
        }
    };
    public static final VPackDeserializer<QueryExecutionState> QUERY_EXECUTION_STATE = new VPackDeserializer<QueryExecutionState>(){

        public QueryExecutionState deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return QueryExecutionState.valueOf(vpack.getAsString().toUpperCase().replaceAll(" ", "_"));
        }
    };
    public static final VPackDeserializer<ReplicationFactor> REPLICATION_FACTOR = new VPackDeserializer<ReplicationFactor>(){

        public ReplicationFactor deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            ReplicationFactor replicationFactor = new ReplicationFactor();
            if (vpack.isString() && vpack.getAsString().equals("satellite")) {
                replicationFactor.setSatellite(true);
            } else {
                replicationFactor.setReplicationFactor(vpack.getAsInt());
            }
            return replicationFactor;
        }
    };
    public static final VPackDeserializer<MinReplicationFactor> MIN_REPLICATION_FACTOR = new VPackDeserializer<MinReplicationFactor>(){

        public MinReplicationFactor deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            MinReplicationFactor minReplicationFactor = new MinReplicationFactor();
            minReplicationFactor.setMinReplicationFactor(vpack.getAsInt());
            return minReplicationFactor;
        }
    };
    public static final VPackDeserializer<ViewType> VIEW_TYPE = new VPackDeserializer<ViewType>(){

        public ViewType deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return "arangosearch".equals(vpack.getAsString()) ? ViewType.ARANGO_SEARCH : ViewType.valueOf(vpack.getAsString().toUpperCase());
        }
    };
    public static final VPackDeserializer<ArangoSearchProperties> ARANGO_SEARCH_PROPERTIES = new VPackDeserializer<ArangoSearchProperties>(){

        public ArangoSearchProperties deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            VPackSlice primarySorts;
            VPackSlice links;
            VPackSlice consolidationPolicy;
            VPackSlice cleanupIntervalStep;
            VPackSlice commitIntervalMsec;
            ArangoSearchProperties properties = new ArangoSearchProperties();
            VPackSlice consolidationIntervalMsec = vpack.get("consolidationIntervalMsec");
            if (consolidationIntervalMsec.isInteger()) {
                properties.setConsolidationIntervalMsec(consolidationIntervalMsec.getAsLong());
            }
            if ((commitIntervalMsec = vpack.get("commitIntervalMsec")).isInteger()) {
                properties.setCommitIntervalMsec(commitIntervalMsec.getAsLong());
            }
            if ((cleanupIntervalStep = vpack.get("cleanupIntervalStep")).isInteger()) {
                properties.setCleanupIntervalStep(cleanupIntervalStep.getAsLong());
            }
            if ((consolidationPolicy = vpack.get("consolidationPolicy")).isObject()) {
                properties.setConsolidationPolicy((ConsolidationPolicy)context.deserialize(consolidationPolicy, ConsolidationPolicy.class));
            }
            if ((links = vpack.get("links")).isObject()) {
                Iterator collectionIterator = links.objectIterator();
                while (collectionIterator.hasNext()) {
                    VPackSlice fields;
                    VPackSlice storeValues;
                    VPackSlice trackListPositions;
                    VPackSlice includeAllFields;
                    Map.Entry entry = (Map.Entry)collectionIterator.next();
                    VPackSlice value = (VPackSlice)entry.getValue();
                    CollectionLink link = CollectionLink.on((String)entry.getKey());
                    VPackSlice analyzers = value.get("analyzers");
                    if (analyzers.isArray()) {
                        Iterator analyzerIterator = analyzers.arrayIterator();
                        while (analyzerIterator.hasNext()) {
                            link.analyzers(((VPackSlice)analyzerIterator.next()).getAsString());
                        }
                    }
                    if ((includeAllFields = value.get("includeAllFields")).isBoolean()) {
                        link.includeAllFields(includeAllFields.getAsBoolean());
                    }
                    if ((trackListPositions = value.get("trackListPositions")).isBoolean()) {
                        link.trackListPositions(trackListPositions.getAsBoolean());
                    }
                    if ((storeValues = value.get("storeValues")).isString()) {
                        link.storeValues(StoreValuesType.valueOf(storeValues.getAsString().toUpperCase()));
                    }
                    if ((fields = value.get("fields")).isObject()) {
                        Iterator fieldsIterator = fields.objectIterator();
                        while (fieldsIterator.hasNext()) {
                            link.fields(VPackDeserializers.deserializeField((Map.Entry)fieldsIterator.next()));
                        }
                    }
                    properties.addLink(link);
                }
            }
            if ((primarySorts = vpack.get("primarySort")).isArray()) {
                Iterator primarySortsIterator = primarySorts.arrayIterator();
                while (primarySortsIterator.hasNext()) {
                    VPackSlice entry = (VPackSlice)primarySortsIterator.next();
                    if (!entry.isObject() || !entry.get("field").isString() || !entry.get("asc").isBoolean()) continue;
                    PrimarySort primarySort = PrimarySort.on(entry.get("field").getAsString());
                    primarySort.ascending(entry.get("asc").getAsBoolean());
                    properties.addPrimarySort(primarySort);
                }
            }
            return properties;
        }
    };
    public static final VPackDeserializer<ArangoSearchPropertiesEntity> ARANGO_SEARCH_PROPERTIES_ENTITY = new VPackDeserializer<ArangoSearchPropertiesEntity>(){

        public ArangoSearchPropertiesEntity deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            ViewEntity entity = (ViewEntity)context.deserialize(vpack, ViewEntity.class);
            ArangoSearchProperties properties = (ArangoSearchProperties)context.deserialize(vpack, ArangoSearchProperties.class);
            ArangoSearchPropertiesEntity result = new ArangoSearchPropertiesEntity(entity.getId(), entity.getName(), entity.getType(), properties);
            return result;
        }
    };
    public static final VPackDeserializer<ConsolidationPolicy> CONSOLIDATE = new VPackDeserializer<ConsolidationPolicy>(){

        public ConsolidationPolicy deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            VPackSlice type = vpack.get("type");
            if (type.isString()) {
                VPackSlice segmentThreshold;
                ConsolidationPolicy consolidate = ConsolidationPolicy.of(ConsolidationType.valueOf(type.getAsString().toUpperCase()));
                VPackSlice threshold = vpack.get("threshold");
                if (threshold.isNumber()) {
                    consolidate.threshold(threshold.getAsDouble());
                }
                if ((segmentThreshold = vpack.get("segmentThreshold")).isInteger()) {
                    consolidate.segmentThreshold(segmentThreshold.getAsLong());
                }
                return consolidate;
            }
            return null;
        }
    };

    protected static FieldLink deserializeField(Map.Entry<String, VPackSlice> field) {
        VPackSlice fields;
        VPackSlice storeValues;
        VPackSlice trackListPositions;
        VPackSlice includeAllFields;
        VPackSlice value = field.getValue();
        FieldLink link = FieldLink.on(field.getKey());
        VPackSlice analyzers = value.get("analyzers");
        if (analyzers.isArray()) {
            Iterator analyzerIterator = analyzers.arrayIterator();
            while (analyzerIterator.hasNext()) {
                link.analyzers(((VPackSlice)analyzerIterator.next()).getAsString());
            }
        }
        if ((includeAllFields = value.get("includeAllFields")).isBoolean()) {
            link.includeAllFields(includeAllFields.getAsBoolean());
        }
        if ((trackListPositions = value.get("trackListPositions")).isBoolean()) {
            link.trackListPositions(trackListPositions.getAsBoolean());
        }
        if ((storeValues = value.get("storeValues")).isString()) {
            link.storeValues(StoreValuesType.valueOf(storeValues.getAsString().toUpperCase()));
        }
        if ((fields = value.get("fields")).isObject()) {
            Iterator fieldsIterator = fields.objectIterator();
            while (fieldsIterator.hasNext()) {
                link.fields(VPackDeserializers.deserializeField((Map.Entry)fieldsIterator.next()));
            }
        }
        return link;
    }
}

