/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.net;

import com.arangodb.internal.net.Host;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostSet.class);
    private ArrayList<Host> hosts = new ArrayList();

    public HostSet() {
    }

    public HostSet(List<Host> hosts) {
        for (Host host : hosts) {
            this.addHost(host);
        }
    }

    public List<Host> getHostsList() {
        return Collections.unmodifiableList(this.hosts);
    }

    public void addHost(Host newHost) {
        if (this.hosts.contains(newHost)) {
            LOGGER.debug("Host" + newHost + " allready in Set");
            for (Host host : this.hosts) {
                if (!host.equals(newHost)) continue;
                host.setMarkforDeletion(false);
            }
        } else {
            this.hosts.add(newHost);
            LOGGER.debug("Added Host " + newHost + " - now " + this.hosts.size() + " Hosts in List");
        }
    }

    public void close() {
        LOGGER.debug("Close all Hosts in Set");
        for (Host host : this.hosts) {
            try {
                LOGGER.debug("Try to close Host " + host);
                host.close();
            }
            catch (IOException e) {
                LOGGER.warn("Error during closing the Host " + host, (Throwable)e);
            }
        }
    }

    public void markAllForDeletion() {
        for (Host host : this.hosts) {
            host.setMarkforDeletion(true);
        }
    }

    public void clearAllMarkedForDeletion() throws IOException {
        LOGGER.debug("Clear all Hosts in Set with markForDeletion");
        for (Host host : this.hosts) {
            if (!host.isMarkforDeletion()) continue;
            try {
                LOGGER.debug("Try to close Host " + host);
                host.close();
            }
            catch (IOException e) {
                LOGGER.warn("Error during closing the Host " + host, (Throwable)e);
            }
        }
    }

    public void clear() {
        LOGGER.debug("Clear all Hosts in Set");
        this.close();
        this.hosts.clear();
    }
}

