/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.entity.DocumentField;
import com.arangodb.entity.VertexEntity;
import com.arangodb.entity.VertexUpdateEntity;
import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.InternalArangoDB;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.internal.InternalArangoGraph;
import com.arangodb.internal.util.ArangoSerializationFactory;
import com.arangodb.internal.util.DocumentUtil;
import com.arangodb.internal.util.RequestUtils;
import com.arangodb.model.GraphDocumentReadOptions;
import com.arangodb.model.VertexCreateOptions;
import com.arangodb.model.VertexDeleteOptions;
import com.arangodb.model.VertexReplaceOptions;
import com.arangodb.model.VertexUpdateOptions;
import com.arangodb.util.ArangoSerializer;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.RequestType;
import com.arangodb.velocystream.Response;
import java.lang.reflect.Type;
import java.util.HashMap;

public abstract class InternalArangoVertexCollection<A extends InternalArangoDB<E>, D extends InternalArangoDatabase<A, E>, G extends InternalArangoGraph<A, D, E>, E extends ArangoExecutor>
extends ArangoExecuteable<E> {
    private static final String PATH_API_GHARIAL = "/_api/gharial";
    private static final String VERTEX = "vertex";
    private final G graph;
    private final String name;

    protected InternalArangoVertexCollection(G graph, String name) {
        super(((InternalArangoGraph)graph).executor, ((InternalArangoGraph)graph).util, ((InternalArangoGraph)graph).context);
        this.graph = graph;
        this.name = name;
    }

    public G graph() {
        return this.graph;
    }

    public String name() {
        return this.name;
    }

    protected Request dropRequest() {
        return this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.DELETE, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), VERTEX, this.name);
    }

    protected <T> Request insertVertexRequest(T value, VertexCreateOptions options) {
        Request request = this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.POST, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), VERTEX, this.name);
        VertexCreateOptions params = options != null ? options : new VertexCreateOptions();
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.setBody(this.util(ArangoSerializationFactory.Serializer.CUSTOM).serialize(value));
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<VertexEntity> insertVertexResponseDeserializer(final T value) {
        return new ArangoExecutor.ResponseDeserializer<VertexEntity>(){

            @Override
            public VertexEntity deserialize(Response response) throws VPackException {
                VPackSlice body = response.getBody().get(InternalArangoVertexCollection.VERTEX);
                VertexEntity doc = (VertexEntity)InternalArangoVertexCollection.this.util().deserialize(body, (Type)((Object)VertexEntity.class));
                HashMap<DocumentField.Type, String> values = new HashMap<DocumentField.Type, String>();
                values.put(DocumentField.Type.ID, doc.getId());
                values.put(DocumentField.Type.KEY, doc.getKey());
                values.put(DocumentField.Type.REV, doc.getRev());
                InternalArangoVertexCollection.this.executor.documentCache().setValues(value, values);
                return doc;
            }
        };
    }

    protected Request getVertexRequest(String key, GraphDocumentReadOptions options) {
        Request request = this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.GET, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), VERTEX, DocumentUtil.createDocumentHandle(this.name, key));
        GraphDocumentReadOptions params = options != null ? options : new GraphDocumentReadOptions();
        request.putHeaderParam("If-None-Match", params.getIfNoneMatch());
        request.putHeaderParam("If-Match", params.getIfMatch());
        if (params.getAllowDirtyRead() == Boolean.TRUE) {
            RequestUtils.allowDirtyRead(request);
        }
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<T> getVertexResponseDeserializer(final Class<T> type) {
        return new ArangoExecutor.ResponseDeserializer<T>(){

            @Override
            public T deserialize(Response response) throws VPackException {
                return InternalArangoVertexCollection.this.util(ArangoSerializationFactory.Serializer.CUSTOM).deserialize(response.getBody().get(InternalArangoVertexCollection.VERTEX), type);
            }
        };
    }

    protected <T> Request replaceVertexRequest(String key, T value, VertexReplaceOptions options) {
        Request request = this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.PUT, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), VERTEX, DocumentUtil.createDocumentHandle(this.name, key));
        VertexReplaceOptions params = options != null ? options : new VertexReplaceOptions();
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.setBody(this.util(ArangoSerializationFactory.Serializer.CUSTOM).serialize(value));
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<VertexUpdateEntity> replaceVertexResponseDeserializer(final T value) {
        return new ArangoExecutor.ResponseDeserializer<VertexUpdateEntity>(){

            @Override
            public VertexUpdateEntity deserialize(Response response) throws VPackException {
                VPackSlice body = response.getBody().get(InternalArangoVertexCollection.VERTEX);
                VertexUpdateEntity doc = (VertexUpdateEntity)InternalArangoVertexCollection.this.util().deserialize(body, (Type)((Object)VertexUpdateEntity.class));
                HashMap<DocumentField.Type, String> values = new HashMap<DocumentField.Type, String>();
                values.put(DocumentField.Type.REV, doc.getRev());
                InternalArangoVertexCollection.this.executor.documentCache().setValues(value, values);
                return doc;
            }
        };
    }

    protected <T> Request updateVertexRequest(String key, T value, VertexUpdateOptions options) {
        Request request = this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.PATCH, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), VERTEX, DocumentUtil.createDocumentHandle(this.name, key));
        VertexUpdateOptions params = options != null ? options : new VertexUpdateOptions();
        request.putQueryParam("keepNull", params.getKeepNull());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.setBody(this.util(ArangoSerializationFactory.Serializer.CUSTOM).serialize(value, new ArangoSerializer.Options().serializeNullValues(true)));
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<VertexUpdateEntity> updateVertexResponseDeserializer(final T value) {
        return new ArangoExecutor.ResponseDeserializer<VertexUpdateEntity>(){

            @Override
            public VertexUpdateEntity deserialize(Response response) throws VPackException {
                VPackSlice body = response.getBody().get(InternalArangoVertexCollection.VERTEX);
                VertexUpdateEntity doc = (VertexUpdateEntity)InternalArangoVertexCollection.this.util().deserialize(body, (Type)((Object)VertexUpdateEntity.class));
                HashMap<DocumentField.Type, String> values = new HashMap<DocumentField.Type, String>();
                values.put(DocumentField.Type.REV, doc.getRev());
                InternalArangoVertexCollection.this.executor.documentCache().setValues(value, values);
                return doc;
            }
        };
    }

    protected Request deleteVertexRequest(String key, VertexDeleteOptions options) {
        Request request = this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.DELETE, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), VERTEX, DocumentUtil.createDocumentHandle(this.name, key));
        VertexDeleteOptions params = options != null ? options : new VertexDeleteOptions();
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putHeaderParam("If-Match", params.getIfMatch());
        return request;
    }
}

