/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.entity.EdgeDefinition;
import com.arangodb.entity.GraphEntity;
import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.InternalArangoDB;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.model.OptionsBuilder;
import com.arangodb.model.VertexCollectionCreateOptions;
import com.arangodb.velocypack.Type;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.RequestType;
import com.arangodb.velocystream.Response;
import java.util.Collection;

public abstract class InternalArangoGraph<A extends InternalArangoDB<E>, D extends InternalArangoDatabase<A, E>, E extends ArangoExecutor>
extends ArangoExecuteable<E> {
    protected static final String PATH_API_GHARIAL = "/_api/gharial";
    private static final String GRAPH = "graph";
    private static final String VERTEX = "vertex";
    private static final String EDGE = "edge";
    private final D db;
    private final String name;

    protected InternalArangoGraph(D db, String name) {
        super(((InternalArangoDatabase)db).executor, ((InternalArangoDatabase)db).util, ((InternalArangoDatabase)db).context);
        this.db = db;
        this.name = name;
    }

    public D db() {
        return this.db;
    }

    public String name() {
        return this.name;
    }

    protected Request dropRequest() {
        return this.dropRequest(false);
    }

    protected Request dropRequest(boolean dropCollections) {
        Request request = this.request(((InternalArangoDatabase)this.db).name(), RequestType.DELETE, PATH_API_GHARIAL, this.name);
        if (dropCollections) {
            request.putQueryParam("dropCollections", dropCollections);
        }
        return request;
    }

    protected Request getInfoRequest() {
        return this.request(((InternalArangoDatabase)this.db).name(), RequestType.GET, PATH_API_GHARIAL, this.name);
    }

    protected ArangoExecutor.ResponseDeserializer<GraphEntity> getInfoResponseDeserializer() {
        return this.addVertexCollectionResponseDeserializer();
    }

    protected Request getVertexCollectionsRequest() {
        return this.request(((InternalArangoDatabase)this.db).name(), RequestType.GET, PATH_API_GHARIAL, this.name, VERTEX);
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<String>> getVertexCollectionsResponseDeserializer() {
        return new ArangoExecutor.ResponseDeserializer<Collection<String>>(){

            @Override
            public Collection<String> deserialize(Response response) throws VPackException {
                return (Collection)InternalArangoGraph.this.util().deserialize(response.getBody().get("collections"), new Type<Collection<String>>(){}.getType());
            }
        };
    }

    protected Request addVertexCollectionRequest(String name) {
        Request request = this.request(((InternalArangoDatabase)this.db).name(), RequestType.POST, PATH_API_GHARIAL, this.name(), VERTEX);
        request.setBody(this.util().serialize(OptionsBuilder.build(new VertexCollectionCreateOptions(), name)));
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<GraphEntity> addVertexCollectionResponseDeserializer() {
        return this.addEdgeDefinitionResponseDeserializer();
    }

    protected Request getEdgeDefinitionsRequest() {
        return this.request(((InternalArangoDatabase)this.db).name(), RequestType.GET, PATH_API_GHARIAL, this.name, EDGE);
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<String>> getEdgeDefinitionsDeserializer() {
        return new ArangoExecutor.ResponseDeserializer<Collection<String>>(){

            @Override
            public Collection<String> deserialize(Response response) throws VPackException {
                return (Collection)InternalArangoGraph.this.util().deserialize(response.getBody().get("collections"), new Type<Collection<String>>(){}.getType());
            }
        };
    }

    protected Request addEdgeDefinitionRequest(EdgeDefinition definition) {
        Request request = this.request(((InternalArangoDatabase)this.db).name(), RequestType.POST, PATH_API_GHARIAL, this.name, EDGE);
        request.setBody(this.util().serialize(definition));
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<GraphEntity> addEdgeDefinitionResponseDeserializer() {
        return new ArangoExecutor.ResponseDeserializer<GraphEntity>(){

            @Override
            public GraphEntity deserialize(Response response) throws VPackException {
                return (GraphEntity)InternalArangoGraph.this.util().deserialize(response.getBody().get(InternalArangoGraph.GRAPH), (java.lang.reflect.Type)((Object)GraphEntity.class));
            }
        };
    }

    protected Request replaceEdgeDefinitionRequest(EdgeDefinition definition) {
        Request request = this.request(((InternalArangoDatabase)this.db).name(), RequestType.PUT, PATH_API_GHARIAL, this.name, EDGE, definition.getCollection());
        request.setBody(this.util().serialize(definition));
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<GraphEntity> replaceEdgeDefinitionResponseDeserializer() {
        return new ArangoExecutor.ResponseDeserializer<GraphEntity>(){

            @Override
            public GraphEntity deserialize(Response response) throws VPackException {
                return (GraphEntity)InternalArangoGraph.this.util().deserialize(response.getBody().get(InternalArangoGraph.GRAPH), (java.lang.reflect.Type)((Object)GraphEntity.class));
            }
        };
    }

    protected Request removeEdgeDefinitionRequest(String definitionName) {
        return this.request(((InternalArangoDatabase)this.db).name(), RequestType.DELETE, PATH_API_GHARIAL, this.name, EDGE, definitionName);
    }

    protected ArangoExecutor.ResponseDeserializer<GraphEntity> removeEdgeDefinitionResponseDeserializer() {
        return new ArangoExecutor.ResponseDeserializer<GraphEntity>(){

            @Override
            public GraphEntity deserialize(Response response) throws VPackException {
                return (GraphEntity)InternalArangoGraph.this.util().deserialize(response.getBody().get(InternalArangoGraph.GRAPH), (java.lang.reflect.Type)((Object)GraphEntity.class));
            }
        };
    }
}

