/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.internal.DocumentCache;
import com.arangodb.internal.util.ArangoSerializationFactory;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocystream.Response;
import java.lang.reflect.Type;

public abstract class ArangoExecutor {
    private final DocumentCache documentCache;
    private final ArangoSerialization util;

    protected ArangoExecutor(ArangoSerializationFactory util, DocumentCache documentCache) {
        this.documentCache = documentCache;
        this.util = util.get(ArangoSerializationFactory.Serializer.INTERNAL);
    }

    public DocumentCache documentCache() {
        return this.documentCache;
    }

    protected <T> T createResult(Type type, Response response) {
        return type != Void.class && response.getBody() != null ? (T)this.util.deserialize(response.getBody(), type) : null;
    }

    public static interface ResponseDeserializer<T> {
        public T deserialize(Response var1) throws VPackException;
    }
}

