/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabase;
import com.arangodb.ArangoSerializationAccessor;
import com.arangodb.Protocol;
import com.arangodb.entity.ArangoDBEngine;
import com.arangodb.entity.ArangoDBVersion;
import com.arangodb.entity.LoadBalancingStrategy;
import com.arangodb.entity.LogEntity;
import com.arangodb.entity.LogLevelEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.ServerRole;
import com.arangodb.entity.UserEntity;
import com.arangodb.internal.ArangoContext;
import com.arangodb.internal.ArangoDBImpl;
import com.arangodb.internal.ArangoDefaults;
import com.arangodb.internal.InternalArangoDBBuilder;
import com.arangodb.internal.http.HttpCommunication;
import com.arangodb.internal.http.HttpConnectionFactory;
import com.arangodb.internal.net.ConnectionFactory;
import com.arangodb.internal.net.Host;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.net.HostResolver;
import com.arangodb.internal.util.ArangoDeserializerImpl;
import com.arangodb.internal.util.ArangoSerializationFactory;
import com.arangodb.internal.util.ArangoSerializerImpl;
import com.arangodb.internal.util.DefaultArangoSerialization;
import com.arangodb.internal.velocystream.VstCommunicationSync;
import com.arangodb.internal.velocystream.VstConnectionFactorySync;
import com.arangodb.model.LogOptions;
import com.arangodb.model.UserCreateOptions;
import com.arangodb.model.UserUpdateOptions;
import com.arangodb.util.ArangoCursorInitializer;
import com.arangodb.util.ArangoDeserializer;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.util.ArangoSerializer;
import com.arangodb.velocypack.VPack;
import com.arangodb.velocypack.VPackAnnotationFieldFilter;
import com.arangodb.velocypack.VPackAnnotationFieldNaming;
import com.arangodb.velocypack.VPackDeserializer;
import com.arangodb.velocypack.VPackInstanceCreator;
import com.arangodb.velocypack.VPackJsonDeserializer;
import com.arangodb.velocypack.VPackJsonSerializer;
import com.arangodb.velocypack.VPackModule;
import com.arangodb.velocypack.VPackParser;
import com.arangodb.velocypack.VPackParserModule;
import com.arangodb.velocypack.VPackSerializer;
import com.arangodb.velocypack.ValueType;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.Response;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Properties;
import javax.net.ssl.SSLContext;

public interface ArangoDB
extends ArangoSerializationAccessor {
    public void shutdown() throws ArangoDBException;

    public ArangoDatabase db();

    public ArangoDatabase db(String var1);

    public Boolean createDatabase(String var1) throws ArangoDBException;

    public Collection<String> getDatabases() throws ArangoDBException;

    public Collection<String> getAccessibleDatabases() throws ArangoDBException;

    public Collection<String> getAccessibleDatabasesFor(String var1) throws ArangoDBException;

    public ArangoDBVersion getVersion() throws ArangoDBException;

    public ArangoDBEngine getEngine() throws ArangoDBException;

    public ServerRole getRole() throws ArangoDBException;

    public UserEntity createUser(String var1, String var2) throws ArangoDBException;

    public UserEntity createUser(String var1, String var2, UserCreateOptions var3) throws ArangoDBException;

    public void deleteUser(String var1) throws ArangoDBException;

    public UserEntity getUser(String var1) throws ArangoDBException;

    public Collection<UserEntity> getUsers() throws ArangoDBException;

    public UserEntity updateUser(String var1, UserUpdateOptions var2) throws ArangoDBException;

    public UserEntity replaceUser(String var1, UserUpdateOptions var2) throws ArangoDBException;

    public void grantDefaultDatabaseAccess(String var1, Permissions var2) throws ArangoDBException;

    public void grantDefaultCollectionAccess(String var1, Permissions var2) throws ArangoDBException;

    public Response execute(Request var1) throws ArangoDBException;

    public Response execute(Request var1, HostHandle var2) throws ArangoDBException;

    public LogEntity getLogs(LogOptions var1) throws ArangoDBException;

    public LogLevelEntity getLogLevel() throws ArangoDBException;

    public LogLevelEntity setLogLevel(LogLevelEntity var1) throws ArangoDBException;

    public ArangoDB _setCursorInitializer(ArangoCursorInitializer var1);

    public static class Builder
    extends InternalArangoDBBuilder {
        private static String PROPERTY_KEY_PROTOCOL = "arangodb.protocol";
        protected Protocol protocol;

        @Override
        protected void loadProperties(Properties properties) {
            super.loadProperties(properties);
            this.protocol = Builder.loadProtocol(properties, this.protocol);
        }

        private static Protocol loadProtocol(Properties properties, Protocol currentValue) {
            return Protocol.valueOf(Builder.getProperty(properties, PROPERTY_KEY_PROTOCOL, currentValue, ArangoDefaults.DEFAULT_NETWORK_PROTOCOL).toUpperCase());
        }

        public Builder useProtocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public Builder loadProperties(InputStream in) throws ArangoDBException {
            super.loadProperties(in);
            return this;
        }

        public Builder host(String host, int port) {
            this.setHost(host, port);
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.setTimeout(timeout);
            return this;
        }

        public Builder user(String user) {
            this.setUser(user);
            return this;
        }

        public Builder password(String password) {
            this.setPassword(password);
            return this;
        }

        public Builder useSsl(Boolean useSsl) {
            this.setUseSsl(useSsl);
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.setSslContext(sslContext);
            return this;
        }

        public Builder chunksize(Integer chunksize) {
            this.setChunksize(chunksize);
            return this;
        }

        public Builder maxConnections(Integer maxConnections) {
            this.setMaxConnections(maxConnections);
            return this;
        }

        public Builder connectionTtl(Long connectionTtl) {
            this.setConnectionTtl(connectionTtl);
            return this;
        }

        public Builder acquireHostList(Boolean acquireHostList) {
            this.setAcquireHostList(acquireHostList);
            return this;
        }

        public Builder acquireHostListInterval(Integer acquireHostListInterval) {
            this.setAcquireHostListInterval(acquireHostListInterval);
            return this;
        }

        public Builder loadBalancingStrategy(LoadBalancingStrategy loadBalancingStrategy) {
            this.setLoadBalancingStrategy(loadBalancingStrategy);
            return this;
        }

        public <T> Builder registerSerializer(Class<T> clazz, VPackSerializer<T> serializer) {
            this.vpackBuilder.registerSerializer(clazz, serializer);
            return this;
        }

        public <T> Builder registerEnclosingSerializer(Class<T> clazz, VPackSerializer<T> serializer) {
            this.vpackBuilder.registerEnclosingSerializer(clazz, serializer);
            return this;
        }

        public <T> Builder registerDeserializer(Class<T> clazz, VPackDeserializer<T> deserializer) {
            this.vpackBuilder.registerDeserializer(clazz, deserializer);
            return this;
        }

        public <T> Builder registerInstanceCreator(Class<T> clazz, VPackInstanceCreator<T> creator) {
            this.vpackBuilder.registerInstanceCreator(clazz, creator);
            return this;
        }

        public Builder registerJsonDeserializer(ValueType type, VPackJsonDeserializer deserializer) {
            this.vpackParserBuilder.registerDeserializer(type, deserializer);
            return this;
        }

        public Builder registerJsonDeserializer(String attribute, ValueType type, VPackJsonDeserializer deserializer) {
            this.vpackParserBuilder.registerDeserializer(attribute, type, deserializer);
            return this;
        }

        public <T> Builder registerJsonSerializer(Class<T> clazz, VPackJsonSerializer<T> serializer) {
            this.vpackParserBuilder.registerSerializer(clazz, serializer);
            return this;
        }

        public <T> Builder registerJsonSerializer(String attribute, Class<T> clazz, VPackJsonSerializer<T> serializer) {
            this.vpackParserBuilder.registerSerializer(attribute, clazz, serializer);
            return this;
        }

        public <A extends Annotation> Builder annotationFieldFilter(Class<A> type, VPackAnnotationFieldFilter<A> fieldFilter) {
            this.vpackBuilder.annotationFieldFilter(type, fieldFilter);
            return this;
        }

        public <A extends Annotation> Builder annotationFieldNaming(Class<A> type, VPackAnnotationFieldNaming<A> fieldNaming) {
            this.vpackBuilder.annotationFieldNaming(type, fieldNaming);
            return this;
        }

        public Builder registerModule(VPackModule module) {
            this.vpackBuilder.registerModule(module);
            return this;
        }

        public Builder registerModules(VPackModule ... modules) {
            this.vpackBuilder.registerModules(modules);
            return this;
        }

        public Builder registerJsonModule(VPackParserModule module) {
            this.vpackParserBuilder.registerModule(module);
            return this;
        }

        public Builder registerJsonModules(VPackParserModule ... modules) {
            this.vpackParserBuilder.registerModules(modules);
            return this;
        }

        @Deprecated
        public Builder setSerializer(ArangoSerializer serializer) {
            this.serializer(serializer);
            return this;
        }

        @Deprecated
        public Builder setDeserializer(ArangoDeserializer deserializer) {
            this.deserializer(deserializer);
            return this;
        }

        public Builder serializer(ArangoSerialization serialization) {
            this.setSerializer(serialization);
            return this;
        }

        public synchronized ArangoDB build() {
            if (this.hosts.isEmpty()) {
                this.hosts.add(this.host);
            }
            VPack vpacker = this.vpackBuilder.serializeNullValues(false).build();
            VPack vpackerNull = this.vpackBuilder.serializeNullValues(true).build();
            VPackParser vpackParser = this.vpackParserBuilder.build();
            ArangoSerializer serializerTemp = this.serializer != null ? this.serializer : new ArangoSerializerImpl(vpacker, vpackerNull, vpackParser);
            ArangoDeserializer deserializerTemp = this.deserializer != null ? this.deserializer : new ArangoDeserializerImpl(vpackerNull, vpackParser);
            DefaultArangoSerialization internal = new DefaultArangoSerialization(serializerTemp, deserializerTemp);
            ArangoSerialization custom = this.customSerializer != null ? this.customSerializer : internal;
            ArangoSerializationFactory util = new ArangoSerializationFactory(internal, custom);
            int protocolMaxConnections = this.protocol == Protocol.VST ? 1 : 20;
            int max = this.maxConnections != null ? Math.max(1, this.maxConnections) : protocolMaxConnections;
            ConnectionFactory connectionFactory = this.protocol == null || Protocol.VST == this.protocol ? new VstConnectionFactorySync(this.host, this.timeout, this.connectionTtl, this.useSsl, this.sslContext) : new HttpConnectionFactory(this.timeout, this.user, this.password, this.useSsl, this.sslContext, custom, this.protocol, this.connectionTtl, this.httpCookieSpec);
            Collection<Host> hostList = this.createHostList(max, connectionFactory);
            HostResolver hostResolver = this.createHostResolver(hostList, max, connectionFactory);
            HostHandler hostHandler = this.createHostHandler(hostResolver);
            return new ArangoDBImpl(new VstCommunicationSync.Builder(hostHandler).timeout(this.timeout).user(this.user).password(this.password).useSsl(this.useSsl).sslContext(this.sslContext).chunksize(this.chunksize).maxConnections(this.maxConnections).connectionTtl(this.connectionTtl), new HttpCommunication.Builder(hostHandler), util, this.protocol, hostResolver, new ArangoContext());
        }
    }
}

