/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.velocystream;

import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.annotations.Expose;
import com.arangodb.velocystream.RequestType;
import java.util.HashMap;
import java.util.Map;

public class Request {
    private int version = 1;
    private int type = 1;
    private final String database;
    private final RequestType requestType;
    private final String request;
    private Map<String, String> queryParam;
    private Map<String, String> headerParam;
    @Expose(serialize=false)
    private VPackSlice body;

    public Request(String database, RequestType requestType, String path) {
        this.database = database;
        this.requestType = requestType;
        this.request = path;
        this.body = null;
        this.queryParam = new HashMap<String, String>();
        this.headerParam = new HashMap<String, String>();
    }

    public int getVersion() {
        return this.version;
    }

    public Request setVersion(int version) {
        this.version = version;
        return this;
    }

    public int getType() {
        return this.type;
    }

    public Request setType(int type) {
        this.type = type;
        return this;
    }

    public String getDatabase() {
        return this.database;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public String getRequest() {
        return this.request;
    }

    public Map<String, String> getQueryParam() {
        if (this.queryParam == null) {
            this.queryParam = new HashMap<String, String>();
        }
        return this.queryParam;
    }

    public Request putQueryParam(String key, Object value) {
        if (value != null) {
            this.getQueryParam().put(key, value.toString());
        }
        return this;
    }

    public Map<String, String> getHeaderParam() {
        if (this.headerParam == null) {
            this.headerParam = new HashMap<String, String>();
        }
        return this.headerParam;
    }

    public Request putHeaderParam(String key, String value) {
        if (value != null) {
            this.getHeaderParam().put(key, value);
        }
        return this;
    }

    public VPackSlice getBody() {
        return this.body;
    }

    public Request setBody(VPackSlice body) {
        this.body = body;
        return this;
    }
}

