/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.model;

import com.arangodb.entity.EdgeDefinition;
import java.util.Arrays;
import java.util.Collection;

public class GraphCreateOptions {
    private String name;
    private Collection<EdgeDefinition> edgeDefinitions;
    private Collection<String> orphanCollections;
    private Boolean isSmart;
    private SmartOptions options;

    protected String getName() {
        return this.name;
    }

    protected GraphCreateOptions name(String name) {
        this.name = name;
        return this;
    }

    public Collection<EdgeDefinition> getEdgeDefinitions() {
        return this.edgeDefinitions;
    }

    protected GraphCreateOptions edgeDefinitions(Collection<EdgeDefinition> edgeDefinitions) {
        this.edgeDefinitions = edgeDefinitions;
        return this;
    }

    public Collection<String> getOrphanCollections() {
        return this.orphanCollections;
    }

    public GraphCreateOptions orphanCollections(String ... orphanCollections) {
        this.orphanCollections = Arrays.asList(orphanCollections);
        return this;
    }

    public Boolean getIsSmart() {
        return this.isSmart;
    }

    public GraphCreateOptions isSmart(Boolean isSmart) {
        this.isSmart = isSmart;
        return this;
    }

    public Integer getNumberOfShards() {
        return this.getOptions().getNumberOfShards();
    }

    public GraphCreateOptions numberOfShards(Integer numberOfShards) {
        this.getOptions().setNumberOfShards(numberOfShards);
        return this;
    }

    public String getSmartGraphAttribute() {
        return this.getOptions().getSmartGraphAttribute();
    }

    public GraphCreateOptions smartGraphAttribute(String smartGraphAttribute) {
        this.getOptions().setSmartGraphAttribute(smartGraphAttribute);
        return this;
    }

    private SmartOptions getOptions() {
        if (this.options == null) {
            this.options = new SmartOptions();
        }
        return this.options;
    }

    public static class SmartOptions {
        private Integer numberOfShards;
        private String smartGraphAttribute;

        public Integer getNumberOfShards() {
            return this.numberOfShards;
        }

        public void setNumberOfShards(Integer numberOfShards) {
            this.numberOfShards = numberOfShards;
        }

        public String getSmartGraphAttribute() {
            return this.smartGraphAttribute;
        }

        public void setSmartGraphAttribute(String smartGraphAttribute) {
            this.smartGraphAttribute = smartGraphAttribute;
        }
    }
}

