/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.velocystream.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.internal.HostHandler;
import com.arangodb.internal.velocystream.internal.Chunk;
import com.arangodb.internal.velocystream.internal.Connection;
import com.arangodb.internal.velocystream.internal.Message;
import com.arangodb.internal.velocystream.internal.MessageStore;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.net.ssl.SSLContext;

public class ConnectionSync
extends Connection {
    private ConnectionSync(HostHandler hostHandler, Integer timeout, Boolean useSsl, SSLContext sslContext, MessageStore messageStore) {
        super(hostHandler, timeout, useSsl, sslContext, messageStore);
    }

    public Message write(final Message message, Collection<Chunk> chunks) throws ArangoDBException {
        FutureTask<Message> task = new FutureTask<Message>(new Callable<Message>(){

            @Override
            public Message call() throws Exception {
                return ConnectionSync.this.messageStore.get(message.getId());
            }
        });
        this.messageStore.storeMessage(message.getId(), task);
        super.writeIntern(message, chunks);
        try {
            return task.get();
        }
        catch (InterruptedException e) {
            throw new ArangoDBException(e);
        }
        catch (ExecutionException e) {
            throw new ArangoDBException(e);
        }
    }

    public static class Builder {
        private final HostHandler hostHandler;
        private final MessageStore messageStore;
        private Integer timeout;
        private Boolean useSsl;
        private SSLContext sslContext;

        public Builder(HostHandler hostHandler, MessageStore messageStore) {
            this.hostHandler = hostHandler;
            this.messageStore = messageStore;
        }

        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder useSsl(Boolean useSsl) {
            this.useSsl = useSsl;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public ConnectionSync build() {
            return new ConnectionSync(this.hostHandler, this.timeout, this.useSsl, this.sslContext, this.messageStore);
        }
    }
}

