/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.velocystream.internal;

import com.arangodb.internal.velocystream.internal.Connection;
import java.util.LinkedList;

public abstract class ConnectionPool<C extends Connection> {
    private final LinkedList<C> connections;
    private final int maxConnections;

    public ConnectionPool(Integer maxConnections) {
        this.maxConnections = maxConnections != null ? Math.max(1, maxConnections) : 1;
        this.connections = new LinkedList();
    }

    public abstract C createConnection();

    public synchronized C connection() {
        Object c = this.connections.size() < this.maxConnections ? this.createConnection() : (Connection)this.connections.removeFirst();
        this.connections.add(c);
        return c;
    }

    public void disconnect() {
        while (!this.connections.isEmpty()) {
            ((Connection)this.connections.removeLast()).close();
        }
    }
}

