/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.velocystream;

import com.arangodb.ArangoDBException;
import com.arangodb.internal.CollectionCache;
import com.arangodb.internal.HostHandler;
import com.arangodb.internal.velocystream.VstCommunication;
import com.arangodb.internal.velocystream.internal.AuthenticationRequest;
import com.arangodb.internal.velocystream.internal.ConnectionPool;
import com.arangodb.internal.velocystream.internal.ConnectionSync;
import com.arangodb.internal.velocystream.internal.Message;
import com.arangodb.internal.velocystream.internal.MessageStore;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.velocypack.exception.VPackParserException;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.Response;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VstCommunicationSync
extends VstCommunication<Response, ConnectionSync> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VstCommunicationSync.class);
    private final CollectionCache collectionCache;

    protected VstCommunicationSync(final HostHandler hostHandler, final Integer timeout, String user, String password, final Boolean useSsl, final SSLContext sslContext, ArangoSerialization util, CollectionCache collectionCache, Integer chunksize, Integer maxConnections) {
        super(timeout, user, password, useSsl, sslContext, util, chunksize, new ConnectionPool<ConnectionSync>(maxConnections){
            private final ConnectionSync.Builder builder;
            {
                super(maxConnections);
                this.builder = new ConnectionSync.Builder(hostHandler, new MessageStore()).timeout(timeout).useSsl(useSsl).sslContext(sslContext);
            }

            @Override
            public ConnectionSync createConnection() {
                return this.builder.build();
            }
        });
        this.collectionCache = collectionCache;
    }

    @Override
    public Response execute(Request request, ConnectionSync connection) throws ArangoDBException {
        this.connect(connection);
        try {
            Message requestMessage = this.createMessage(request);
            Message responseMessage = this.send(requestMessage, connection);
            this.collectionCache.setDb(request.getDatabase());
            Response response = this.createResponse(responseMessage);
            this.checkError(response);
            return response;
        }
        catch (VPackParserException e) {
            throw new ArangoDBException(e);
        }
    }

    private Message send(Message message, ConnectionSync connection) throws ArangoDBException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Send Message (id=%s, head=%s, body=%s)", message.getId(), message.getHead(), message.getBody() != null ? message.getBody() : "{}"));
        }
        return connection.write(message, this.buildChunks(message));
    }

    @Override
    protected void authenticate(ConnectionSync connection) {
        Response response = this.execute((Request)new AuthenticationRequest(this.user, this.password != null ? this.password : "", "plain"), connection);
        this.checkError(response);
    }

    public static class Builder {
        private final HostHandler hostHandler;
        private Integer timeout;
        private String user;
        private String password;
        private Boolean useSsl;
        private SSLContext sslContext;
        private Integer chunksize;
        private Integer maxConnections;

        public Builder(HostHandler hostHandler) {
            this.hostHandler = hostHandler;
        }

        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder useSsl(Boolean useSsl) {
            this.useSsl = useSsl;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder chunksize(Integer chunksize) {
            this.chunksize = chunksize;
            return this;
        }

        public Builder maxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public VstCommunication<Response, ConnectionSync> build(ArangoSerialization util, CollectionCache collectionCache) {
            return new VstCommunicationSync(this.hostHandler, this.timeout, this.user, this.password, this.useSsl, this.sslContext, util, collectionCache, this.chunksize, this.maxConnections);
        }
    }
}

