/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.velocystream;

import com.arangodb.ArangoDBException;
import com.arangodb.entity.ErrorEntity;
import com.arangodb.internal.velocystream.internal.Chunk;
import com.arangodb.internal.velocystream.internal.Connection;
import com.arangodb.internal.velocystream.internal.ConnectionPool;
import com.arangodb.internal.velocystream.internal.Message;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackParserException;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.Response;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VstCommunication<R, C extends Connection> {
    private static final int ERROR_STATUS = 300;
    private static final Logger LOGGER = LoggerFactory.getLogger(VstCommunication.class);
    protected static final AtomicLong mId = new AtomicLong(0L);
    protected final ArangoSerialization util;
    protected final ConnectionPool<C> connectionPool;
    protected final String user;
    protected final String password;
    protected final Integer chunksize;

    protected VstCommunication(Integer timeout, String user, String password, Boolean useSsl, SSLContext sslContext, ArangoSerialization util, Integer chunksize, ConnectionPool<C> connectionPool) {
        this.user = user;
        this.password = password;
        this.util = util;
        this.connectionPool = connectionPool;
        this.chunksize = chunksize != null ? chunksize : 30000;
    }

    protected void connect(C connection) {
        if (!((Connection)connection).isOpen()) {
            try {
                ((Connection)connection).open();
                if (this.user != null) {
                    this.authenticate(connection);
                }
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new ArangoDBException(e);
            }
        }
    }

    protected abstract void authenticate(C var1);

    public void disconnect() {
        this.connectionPool.disconnect();
    }

    public R execute(Request request) throws ArangoDBException {
        return this.execute(request, this.connectionPool.connection());
    }

    public abstract R execute(Request var1, C var2) throws ArangoDBException;

    protected void checkError(Response response) throws ArangoDBException {
        try {
            if (response.getResponseCode() >= 300) {
                if (response.getBody() != null) {
                    ErrorEntity errorEntity = (ErrorEntity)this.util.deserialize(response.getBody(), (Type)((Object)ErrorEntity.class));
                    throw new ArangoDBException(errorEntity);
                }
                throw new ArangoDBException(String.format("Response Code: %s", response.getResponseCode()), response.getResponseCode());
            }
        }
        catch (VPackParserException e) {
            throw new ArangoDBException(e);
        }
    }

    protected Response createResponse(Message messsage) throws VPackParserException {
        Response response = (Response)this.util.deserialize(messsage.getHead(), (Type)((Object)Response.class));
        if (messsage.getBody() != null) {
            response.setBody(messsage.getBody());
        }
        return response;
    }

    protected Message createMessage(Request request) throws VPackParserException {
        long id = mId.incrementAndGet();
        return new Message(id, this.util.serialize(request), request.getBody());
    }

    protected Collection<Chunk> buildChunks(Message message) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        VPackSlice head = message.getHead();
        int size = head.getByteSize();
        VPackSlice body = message.getBody();
        if (body != null) {
            size += body.getByteSize();
        }
        int n = size / this.chunksize;
        int numberOfChunks = size % this.chunksize != 0 ? n + 1 : n;
        int off = 0;
        int i = 0;
        while (size > 0) {
            int len = Math.min(this.chunksize, size);
            long messageLength = i == 0 && numberOfChunks > 1 ? (long)size : -1L;
            Chunk chunk = new Chunk(message.getId(), i, numberOfChunks, messageLength, off, len);
            size -= len;
            off += len;
            chunks.add(chunk);
            ++i;
        }
        return chunks;
    }
}

