/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.entity.DocumentField;
import com.arangodb.entity.VertexEntity;
import com.arangodb.entity.VertexUpdateEntity;
import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.InternalArangoDB;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.internal.InternalArangoGraph;
import com.arangodb.internal.velocystream.internal.Connection;
import com.arangodb.model.DocumentReadOptions;
import com.arangodb.model.VertexCreateOptions;
import com.arangodb.model.VertexDeleteOptions;
import com.arangodb.model.VertexReplaceOptions;
import com.arangodb.model.VertexUpdateOptions;
import com.arangodb.util.ArangoSerializer;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.RequestType;
import com.arangodb.velocystream.Response;
import java.lang.reflect.Type;
import java.util.HashMap;

public class InternalArangoVertexCollection<A extends InternalArangoDB<E, R, C>, D extends InternalArangoDatabase<A, E, R, C>, G extends InternalArangoGraph<A, D, E, R, C>, E extends ArangoExecutor, R, C extends Connection>
extends ArangoExecuteable<E, R, C> {
    private final G graph;
    private final String name;

    public InternalArangoVertexCollection(G graph, String name) {
        super(((ArangoExecuteable)graph).executor(), ((ArangoExecuteable)graph).util());
        this.graph = graph;
        this.name = name;
    }

    public G graph() {
        return this.graph;
    }

    public String name() {
        return this.name;
    }

    protected Request dropRequest() {
        return new Request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.DELETE, this.executor.createPath("/_api/gharial", ((InternalArangoGraph)this.graph).name(), "vertex", this.name));
    }

    protected <T> Request insertVertexRequest(T value, VertexCreateOptions options) {
        Request request = new Request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.POST, this.executor.createPath("/_api/gharial", ((InternalArangoGraph)this.graph).name(), "vertex", this.name));
        VertexCreateOptions params = options != null ? options : new VertexCreateOptions();
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.setBody(this.util().serialize(value));
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<VertexEntity> insertVertexResponseDeserializer(final T value) {
        return new ArangoExecutor.ResponseDeserializer<VertexEntity>(){

            @Override
            public VertexEntity deserialize(Response response) throws VPackException {
                VPackSlice body = response.getBody().get("vertex");
                VertexEntity doc = (VertexEntity)InternalArangoVertexCollection.this.util().deserialize(body, (Type)((Object)VertexEntity.class));
                HashMap<DocumentField.Type, String> values = new HashMap<DocumentField.Type, String>();
                values.put(DocumentField.Type.ID, doc.getId());
                values.put(DocumentField.Type.KEY, doc.getKey());
                values.put(DocumentField.Type.REV, doc.getRev());
                InternalArangoVertexCollection.this.executor.documentCache().setValues(value, values);
                return doc;
            }
        };
    }

    protected Request getVertexRequest(String key, DocumentReadOptions options) {
        Request request = new Request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.GET, this.executor.createPath("/_api/gharial", ((InternalArangoGraph)this.graph).name(), "vertex", this.executor.createDocumentHandle(this.name, key)));
        DocumentReadOptions params = options != null ? options : new DocumentReadOptions();
        request.putHeaderParam("If-None-Match", params.getIfNoneMatch());
        request.putHeaderParam("If-Match", params.getIfMatch());
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<T> getVertexResponseDeserializer(final Class<T> type) {
        return new ArangoExecutor.ResponseDeserializer<T>(){

            @Override
            public T deserialize(Response response) throws VPackException {
                return InternalArangoVertexCollection.this.util().deserialize(response.getBody().get("vertex"), type);
            }
        };
    }

    protected <T> Request replaceVertexRequest(String key, T value, VertexReplaceOptions options) {
        Request request = new Request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.PUT, this.executor.createPath("/_api/gharial", ((InternalArangoGraph)this.graph).name(), "vertex", this.executor.createDocumentHandle(this.name, key)));
        VertexReplaceOptions params = options != null ? options : new VertexReplaceOptions();
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.setBody(this.util().serialize(value));
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<VertexUpdateEntity> replaceVertexResponseDeserializer(final T value) {
        return new ArangoExecutor.ResponseDeserializer<VertexUpdateEntity>(){

            @Override
            public VertexUpdateEntity deserialize(Response response) throws VPackException {
                VPackSlice body = response.getBody().get("vertex");
                VertexUpdateEntity doc = (VertexUpdateEntity)InternalArangoVertexCollection.this.util().deserialize(body, (Type)((Object)VertexUpdateEntity.class));
                HashMap<DocumentField.Type, String> values = new HashMap<DocumentField.Type, String>();
                values.put(DocumentField.Type.REV, doc.getRev());
                InternalArangoVertexCollection.this.executor.documentCache().setValues(value, values);
                return doc;
            }
        };
    }

    protected <T> Request updateVertexRequest(String key, T value, VertexUpdateOptions options) {
        Request request = new Request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.PATCH, this.executor.createPath("/_api/gharial", ((InternalArangoGraph)this.graph).name(), "vertex", this.executor.createDocumentHandle(this.name, key)));
        VertexUpdateOptions params = options != null ? options : new VertexUpdateOptions();
        request.putQueryParam("keepNull", params.getKeepNull());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.setBody(this.util().serialize(value, new ArangoSerializer.Options().serializeNullValues(true)));
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<VertexUpdateEntity> updateVertexResponseDeserializer(T value) {
        return new ArangoExecutor.ResponseDeserializer<VertexUpdateEntity>(){

            @Override
            public VertexUpdateEntity deserialize(Response response) throws VPackException {
                VPackSlice body = response.getBody().get("vertex");
                return (VertexUpdateEntity)InternalArangoVertexCollection.this.util().deserialize(body, (Type)((Object)VertexUpdateEntity.class));
            }
        };
    }

    protected Request deleteVertexRequest(String key, VertexDeleteOptions options) {
        Request request = new Request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.DELETE, this.executor.createPath("/_api/gharial", ((InternalArangoGraph)this.graph).name(), "vertex", this.executor.createDocumentHandle(this.name, key)));
        VertexDeleteOptions params = options != null ? options : new VertexDeleteOptions();
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putHeaderParam("If-Match", params.getIfMatch());
        return request;
    }
}

