/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.entity.CollectionEntity;
import com.arangodb.entity.DatabaseEntity;
import com.arangodb.entity.EdgeDefinition;
import com.arangodb.entity.GraphEntity;
import com.arangodb.entity.PathEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.QueryCachePropertiesEntity;
import com.arangodb.entity.QueryTrackingPropertiesEntity;
import com.arangodb.entity.TraversalEntity;
import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.InternalArangoDB;
import com.arangodb.internal.velocystream.internal.Connection;
import com.arangodb.model.AqlFunctionCreateOptions;
import com.arangodb.model.AqlFunctionDeleteOptions;
import com.arangodb.model.AqlFunctionGetOptions;
import com.arangodb.model.AqlQueryExplainOptions;
import com.arangodb.model.AqlQueryOptions;
import com.arangodb.model.AqlQueryParseOptions;
import com.arangodb.model.CollectionCreateOptions;
import com.arangodb.model.CollectionsReadOptions;
import com.arangodb.model.GraphCreateOptions;
import com.arangodb.model.OptionsBuilder;
import com.arangodb.model.TransactionOptions;
import com.arangodb.model.TraversalOptions;
import com.arangodb.model.UserAccessOptions;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.velocypack.Type;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.RequestType;
import com.arangodb.velocystream.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class InternalArangoDatabase<A extends InternalArangoDB<E, R, C>, E extends ArangoExecutor, R, C extends Connection>
extends ArangoExecuteable<E, R, C> {
    private final String name;
    private final A arango;

    public InternalArangoDatabase(A arango, E executor, ArangoSerialization util, String name) {
        super(executor, util);
        this.arango = arango;
        this.name = name;
    }

    public A arango() {
        return this.arango;
    }

    public String name() {
        return this.name;
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<String>> getDatabaseResponseDeserializer() {
        return ((InternalArangoDB)this.arango).getDatabaseResponseDeserializer();
    }

    protected Request getAccessibleDatabasesRequest() {
        return new Request(this.name, RequestType.GET, this.executor.createPath("/_api/database", "user"));
    }

    protected Request getVersionRequest() {
        return new Request(this.name, RequestType.GET, "/_api/version");
    }

    protected Request createCollectionRequest(String name, CollectionCreateOptions options) {
        return new Request(this.name(), RequestType.POST, "/_api/collection").setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new CollectionCreateOptions(), name)));
    }

    protected Request getCollectionsRequest(CollectionsReadOptions options) {
        Request request = new Request(this.name(), RequestType.GET, "/_api/collection");
        CollectionsReadOptions params = options != null ? options : new CollectionsReadOptions();
        request.putQueryParam("excludeSystem", params.getExcludeSystem());
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<CollectionEntity>> getCollectionsResponseDeserializer() {
        return new ArangoExecutor.ResponseDeserializer<Collection<CollectionEntity>>(){

            @Override
            public Collection<CollectionEntity> deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("result");
                return (Collection)InternalArangoDatabase.this.util().deserialize(result, new Type<Collection<CollectionEntity>>(){}.getType());
            }
        };
    }

    protected Request dropRequest() {
        return new Request("_system", RequestType.DELETE, this.executor.createPath("/_api/database", this.name));
    }

    protected ArangoExecutor.ResponseDeserializer<Boolean> createDropResponseDeserializer() {
        return new ArangoExecutor.ResponseDeserializer<Boolean>(){

            @Override
            public Boolean deserialize(Response response) throws VPackException {
                return response.getBody().get("result").getAsBoolean();
            }
        };
    }

    protected Request grantAccessRequest(String user, Permissions permissions) {
        return new Request("_system", RequestType.PUT, this.executor.createPath("/_api/user", user, "database", this.name)).setBody(this.util().serialize(OptionsBuilder.build(new UserAccessOptions(), permissions.toString())));
    }

    protected Request resetAccessRequest(String user) {
        return new Request("_system", RequestType.DELETE, this.executor.createPath("/_api/user", user, "database", this.name));
    }

    protected Request updateUserDefaultCollectionAccessRequest(String user, Permissions permissions) {
        return new Request("_system", RequestType.PUT, this.executor.createPath("/_api/user", user, "database", this.name, "*")).setBody(this.util().serialize(OptionsBuilder.build(new UserAccessOptions(), permissions.toString())));
    }

    protected Request queryRequest(String query, Map<String, Object> bindVars, AqlQueryOptions options) {
        return new Request(this.name, RequestType.POST, "/_api/cursor").setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new AqlQueryOptions(), query, bindVars)));
    }

    protected Request queryNextRequest(String id) {
        return new Request(this.name, RequestType.PUT, this.executor.createPath("/_api/cursor", id));
    }

    protected Request queryCloseRequest(String id) {
        return new Request(this.name, RequestType.DELETE, this.executor.createPath("/_api/cursor", id));
    }

    protected Request explainQueryRequest(String query, Map<String, Object> bindVars, AqlQueryExplainOptions options) {
        return new Request(this.name, RequestType.POST, "/_api/explain").setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new AqlQueryExplainOptions(), query, bindVars)));
    }

    protected Request parseQueryRequest(String query) {
        return new Request(this.name, RequestType.POST, "/_api/query").setBody(this.util().serialize(OptionsBuilder.build(new AqlQueryParseOptions(), query)));
    }

    protected Request clearQueryCacheRequest() {
        return new Request(this.name, RequestType.DELETE, "/_api/query-cache");
    }

    protected Request getQueryCachePropertiesRequest() {
        return new Request(this.name, RequestType.GET, "/_api/query-cache/properties");
    }

    protected Request setQueryCachePropertiesRequest(QueryCachePropertiesEntity properties) {
        return new Request(this.name, RequestType.PUT, "/_api/query-cache/properties").setBody(this.util().serialize(properties));
    }

    protected Request getQueryTrackingPropertiesRequest() {
        return new Request(this.name, RequestType.GET, "/_api/query/properties");
    }

    protected Request setQueryTrackingPropertiesRequest(QueryTrackingPropertiesEntity properties) {
        return new Request(this.name, RequestType.PUT, "/_api/query/properties").setBody(this.util().serialize(properties));
    }

    protected Request getCurrentlyRunningQueriesRequest() {
        return new Request(this.name, RequestType.GET, "/_api/query/current");
    }

    protected Request getSlowQueriesRequest() {
        return new Request(this.name, RequestType.GET, "/_api/query/slow");
    }

    protected Request clearSlowQueriesRequest() {
        return new Request(this.name, RequestType.DELETE, "/_api/query/slow");
    }

    protected Request killQueryRequest(String id) {
        return new Request(this.name, RequestType.DELETE, this.executor.createPath("/_api/query", id));
    }

    protected Request createAqlFunctionRequest(String name, String code, AqlFunctionCreateOptions options) {
        return new Request(this.name(), RequestType.POST, "/_api/aqlfunction").setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new AqlFunctionCreateOptions(), name, code)));
    }

    protected Request deleteAqlFunctionRequest(String name, AqlFunctionDeleteOptions options) {
        Request request = new Request(this.name(), RequestType.DELETE, this.executor.createPath("/_api/aqlfunction", name));
        AqlFunctionDeleteOptions params = options != null ? options : new AqlFunctionDeleteOptions();
        request.putQueryParam("group", params.getGroup());
        return request;
    }

    protected Request getAqlFunctionsRequest(AqlFunctionGetOptions options) {
        Request request = new Request(this.name(), RequestType.GET, "/_api/aqlfunction");
        AqlFunctionGetOptions params = options != null ? options : new AqlFunctionGetOptions();
        request.putQueryParam("namespace", params.getNamespace());
        return request;
    }

    protected Request createGraphRequest(String name, Collection<EdgeDefinition> edgeDefinitions, GraphCreateOptions options) {
        return new Request(this.name(), RequestType.POST, "/_api/gharial").setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new GraphCreateOptions(), name, edgeDefinitions)));
    }

    protected ArangoExecutor.ResponseDeserializer<GraphEntity> createGraphResponseDeserializer() {
        return new ArangoExecutor.ResponseDeserializer<GraphEntity>(){

            @Override
            public GraphEntity deserialize(Response response) throws VPackException {
                return (GraphEntity)InternalArangoDatabase.this.util().deserialize(response.getBody().get("graph"), (java.lang.reflect.Type)((Object)GraphEntity.class));
            }
        };
    }

    protected Request getGraphsRequest() {
        return new Request(this.name, RequestType.GET, "/_api/gharial");
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<GraphEntity>> getGraphsResponseDeserializer() {
        return new ArangoExecutor.ResponseDeserializer<Collection<GraphEntity>>(){

            @Override
            public Collection<GraphEntity> deserialize(Response response) throws VPackException {
                return (Collection)InternalArangoDatabase.this.util().deserialize(response.getBody().get("graphs"), new Type<Collection<GraphEntity>>(){}.getType());
            }
        };
    }

    protected Request transactionRequest(String action, TransactionOptions options) {
        return new Request(this.name, RequestType.POST, "/_api/transaction").setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new TransactionOptions(), action)));
    }

    protected <T> ArangoExecutor.ResponseDeserializer<T> transactionResponseDeserializer(final Class<T> type) {
        return new ArangoExecutor.ResponseDeserializer<T>(){

            @Override
            public T deserialize(Response response) throws VPackException {
                VPackSlice result;
                VPackSlice body = response.getBody();
                if (body != null && !(result = body.get("result")).isNone()) {
                    return InternalArangoDatabase.this.util().deserialize(result, type);
                }
                return null;
            }
        };
    }

    protected Request getInfoRequest() {
        return new Request(this.name, RequestType.GET, this.executor.createPath("/_api/database", "current"));
    }

    protected ArangoExecutor.ResponseDeserializer<DatabaseEntity> getInfoResponseDeserializer() {
        return new ArangoExecutor.ResponseDeserializer<DatabaseEntity>(){

            @Override
            public DatabaseEntity deserialize(Response response) throws VPackException {
                return (DatabaseEntity)InternalArangoDatabase.this.util().deserialize(response.getBody().get("result"), (java.lang.reflect.Type)((Object)DatabaseEntity.class));
            }
        };
    }

    protected Request executeTraversalRequest(TraversalOptions options) {
        return new Request(this.name, RequestType.POST, "/_api/traversal").setBody(this.util().serialize(options != null ? options : new TransactionOptions()));
    }

    protected <E, V> ArangoExecutor.ResponseDeserializer<TraversalEntity<V, E>> executeTraversalResponseDeserializer(final Class<V> vertexClass, final Class<E> edgeClass) {
        return new ArangoExecutor.ResponseDeserializer<TraversalEntity<V, E>>(){

            @Override
            public TraversalEntity<V, E> deserialize(Response response) throws VPackException {
                TraversalEntity result = new TraversalEntity();
                VPackSlice visited = response.getBody().get("result").get("visited");
                result.setVertices(InternalArangoDatabase.this.deserializeVertices(vertexClass, visited));
                ArrayList paths = new ArrayList();
                Iterator iterator = visited.get("paths").arrayIterator();
                while (iterator.hasNext()) {
                    PathEntity path = new PathEntity();
                    VPackSlice next = (VPackSlice)iterator.next();
                    path.setEdges(InternalArangoDatabase.this.deserializeEdges(edgeClass, next));
                    path.setVertices(InternalArangoDatabase.this.deserializeVertices(vertexClass, next));
                    paths.add(path);
                }
                result.setPaths(paths);
                return result;
            }
        };
    }

    protected <V> Collection<V> deserializeVertices(Class<V> vertexClass, VPackSlice vpack) throws VPackException {
        ArrayList vertices = new ArrayList();
        Iterator iterator = vpack.get("vertices").arrayIterator();
        while (iterator.hasNext()) {
            vertices.add(this.util().deserialize((VPackSlice)iterator.next(), vertexClass));
        }
        return vertices;
    }

    protected <E> Collection<E> deserializeEdges(Class<E> edgeClass, VPackSlice next) throws VPackException {
        ArrayList edges = new ArrayList();
        Iterator iteratorEdge = next.get("edges").arrayIterator();
        while (iteratorEdge.hasNext()) {
            edges.add(this.util().deserialize((VPackSlice)iteratorEdge.next(), edgeClass));
        }
        return edges;
    }

    protected Request reloadRoutingRequest() {
        return new Request(this.name, RequestType.POST, "/_admin/routing/reload");
    }
}

