/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoCursor;
import com.arangodb.entity.CursorEntity;
import com.arangodb.internal.ArangoCursorExecute;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.velocypack.VPackSlice;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArangoCursorIterator<T>
implements Iterator<T> {
    private CursorEntity result;
    private int pos;
    private final ArangoCursor<T> cursor;
    private final InternalArangoDatabase<?, ?, ?, ?> db;
    private final ArangoCursorExecute execute;

    public ArangoCursorIterator(ArangoCursor<T> cursor, ArangoCursorExecute execute, InternalArangoDatabase<?, ?, ?, ?> db, CursorEntity result) {
        this.cursor = cursor;
        this.execute = execute;
        this.db = db;
        this.result = result;
        this.pos = 0;
    }

    public CursorEntity getResult() {
        return this.result;
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.result.getResult().size() || this.result.getHasMore() != false;
    }

    @Override
    public T next() {
        if (this.pos >= this.result.getResult().size() && this.result.getHasMore().booleanValue()) {
            this.result = this.execute.next(this.cursor.getId());
            this.pos = 0;
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.deserialize(this.result.getResult().get(this.pos++), this.cursor.getType());
    }

    protected <R> R deserialize(VPackSlice result, Class<R> type) {
        return (R)this.db.util().deserialize(result, type);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

