/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.entity;

import com.arangodb.entity.DocumentField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class BaseDocument
implements Serializable {
    private static final long serialVersionUID = -1824742667228719116L;
    @DocumentField(value=DocumentField.Type.ID)
    protected String id;
    @DocumentField(value=DocumentField.Type.KEY)
    protected String key;
    @DocumentField(value=DocumentField.Type.REV)
    protected String revision;
    protected Map<String, Object> properties = new HashMap<String, Object>();

    public BaseDocument() {
    }

    public BaseDocument(String key) {
        this();
        this.key = key;
    }

    public BaseDocument(Map<String, Object> properties) {
        this();
        Object tmpRev;
        Object tmpKey;
        Object tmpId = properties.remove(DocumentField.Type.ID.getSerializeName());
        if (tmpId != null) {
            this.id = tmpId.toString();
        }
        if ((tmpKey = properties.remove(DocumentField.Type.KEY.getSerializeName())) != null) {
            this.key = tmpKey.toString();
        }
        if ((tmpRev = properties.remove(DocumentField.Type.REV.getSerializeName())) != null) {
            this.revision = tmpRev.toString();
        }
        this.properties = properties;
    }

    public String getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void addAttribute(String key, Object value) {
        this.properties.put(key, value);
    }

    public void updateAttribute(String key, Object value) {
        if (this.properties.containsKey(key)) {
            this.properties.put(key, value);
        }
    }

    public Object getAttribute(String key) {
        return this.properties.get(key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BaseDocument [documentRevision=");
        sb.append(this.revision);
        sb.append(", documentHandle=");
        sb.append(this.id);
        sb.append(", documentKey=");
        sb.append(this.key);
        sb.append(", properties=");
        sb.append(this.properties);
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.revision == null ? 0 : this.revision.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseDocument other = (BaseDocument)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return !(this.revision == null ? other.revision != null : !this.revision.equals(other.revision));
    }
}

