/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb;

import com.arangodb.ArangoDB;
import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabase;
import com.arangodb.ArangoGraph;
import com.arangodb.entity.VertexEntity;
import com.arangodb.entity.VertexUpdateEntity;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.InternalArangoVertexCollection;
import com.arangodb.internal.velocystream.internal.ConnectionSync;
import com.arangodb.model.DocumentReadOptions;
import com.arangodb.model.VertexCreateOptions;
import com.arangodb.model.VertexDeleteOptions;
import com.arangodb.model.VertexReplaceOptions;
import com.arangodb.model.VertexUpdateOptions;
import com.arangodb.velocystream.Response;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArangoVertexCollection
extends InternalArangoVertexCollection<ArangoDB, ArangoDatabase, ArangoGraph, ArangoExecutorSync, Response, ConnectionSync> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArangoVertexCollection.class);

    protected ArangoVertexCollection(ArangoGraph graph, String name) {
        super(graph, name);
    }

    public void drop() throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.dropRequest(), (Type)((Object)Void.class));
    }

    public <T> VertexEntity insertVertex(T value) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.insertVertexRequest(value, new VertexCreateOptions()), this.insertVertexResponseDeserializer(value));
    }

    public <T> VertexEntity insertVertex(T value, VertexCreateOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.insertVertexRequest(value, options), this.insertVertexResponseDeserializer(value));
    }

    public <T> T getVertex(String key, Class<T> type) throws ArangoDBException {
        try {
            return ((ArangoExecutorSync)this.executor).execute(this.getVertexRequest(key, new DocumentReadOptions()), this.getVertexResponseDeserializer(type));
        }
        catch (ArangoDBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public <T> T getVertex(String key, Class<T> type, DocumentReadOptions options) throws ArangoDBException {
        try {
            return ((ArangoExecutorSync)this.executor).execute(this.getVertexRequest(key, options), this.getVertexResponseDeserializer(type));
        }
        catch (ArangoDBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public <T> VertexUpdateEntity replaceVertex(String key, T value) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.replaceVertexRequest(key, value, new VertexReplaceOptions()), this.replaceVertexResponseDeserializer(value));
    }

    public <T> VertexUpdateEntity replaceVertex(String key, T value, VertexReplaceOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.replaceVertexRequest(key, value, options), this.replaceVertexResponseDeserializer(value));
    }

    public <T> VertexUpdateEntity updateVertex(String key, T value) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.updateVertexRequest(key, value, new VertexUpdateOptions()), this.updateVertexResponseDeserializer(value));
    }

    public <T> VertexUpdateEntity updateVertex(String key, T value, VertexUpdateOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.updateVertexRequest(key, value, options), this.updateVertexResponseDeserializer(value));
    }

    public void deleteVertex(String key) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.deleteVertexRequest(key, new VertexDeleteOptions()), (Type)((Object)Void.class));
    }

    public void deleteVertex(String key, VertexDeleteOptions options) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.deleteVertexRequest(key, options), (Type)((Object)Void.class));
    }
}

