/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb;

import com.arangodb.ArangoCollection;
import com.arangodb.ArangoCursor;
import com.arangodb.ArangoDB;
import com.arangodb.ArangoDBException;
import com.arangodb.ArangoGraph;
import com.arangodb.entity.AqlExecutionExplainEntity;
import com.arangodb.entity.AqlFunctionEntity;
import com.arangodb.entity.AqlParseEntity;
import com.arangodb.entity.ArangoDBVersion;
import com.arangodb.entity.CollectionEntity;
import com.arangodb.entity.CursorEntity;
import com.arangodb.entity.DatabaseEntity;
import com.arangodb.entity.EdgeDefinition;
import com.arangodb.entity.GraphEntity;
import com.arangodb.entity.IndexEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.QueryCachePropertiesEntity;
import com.arangodb.entity.QueryEntity;
import com.arangodb.entity.QueryTrackingPropertiesEntity;
import com.arangodb.entity.TraversalEntity;
import com.arangodb.internal.ArangoCursorExecute;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.CommunicationProtocol;
import com.arangodb.internal.DocumentCache;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.internal.velocystream.internal.ConnectionSync;
import com.arangodb.model.AqlFunctionCreateOptions;
import com.arangodb.model.AqlFunctionDeleteOptions;
import com.arangodb.model.AqlFunctionGetOptions;
import com.arangodb.model.AqlQueryExplainOptions;
import com.arangodb.model.AqlQueryOptions;
import com.arangodb.model.CollectionCreateOptions;
import com.arangodb.model.CollectionsReadOptions;
import com.arangodb.model.DocumentReadOptions;
import com.arangodb.model.GraphCreateOptions;
import com.arangodb.model.TransactionOptions;
import com.arangodb.model.TraversalOptions;
import com.arangodb.util.ArangoCursorInitializer;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.velocypack.Type;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.Response;
import java.util.Collection;
import java.util.Map;

public class ArangoDatabase
extends InternalArangoDatabase<ArangoDB, ArangoExecutorSync, Response, ConnectionSync> {
    private ArangoCursorInitializer cursorInitializer;

    protected ArangoDatabase(ArangoDB arangoDB, String name) {
        super(arangoDB, arangoDB.executor(), arangoDB.util(), name);
    }

    protected ArangoDatabase(CommunicationProtocol protocol, ArangoSerialization util, DocumentCache documentCache, String name) {
        super(null, new ArangoExecutorSync(protocol, util, documentCache), util, name);
    }

    public ArangoDBVersion getVersion() throws ArangoDBException {
        return (ArangoDBVersion)((ArangoExecutorSync)this.executor).execute(this.getVersionRequest(), (java.lang.reflect.Type)((Object)ArangoDBVersion.class));
    }

    public Collection<String> getAccessibleDatabases() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getAccessibleDatabasesRequest(), this.getDatabaseResponseDeserializer());
    }

    public ArangoCollection collection(String name) {
        return new ArangoCollection(this, name);
    }

    public CollectionEntity createCollection(String name) throws ArangoDBException {
        return (CollectionEntity)((ArangoExecutorSync)this.executor).execute(this.createCollectionRequest(name, new CollectionCreateOptions()), (java.lang.reflect.Type)((Object)CollectionEntity.class));
    }

    public CollectionEntity createCollection(String name, CollectionCreateOptions options) throws ArangoDBException {
        return (CollectionEntity)((ArangoExecutorSync)this.executor).execute(this.createCollectionRequest(name, options), (java.lang.reflect.Type)((Object)CollectionEntity.class));
    }

    public Collection<CollectionEntity> getCollections() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getCollectionsRequest(new CollectionsReadOptions()), this.getCollectionsResponseDeserializer());
    }

    public Collection<CollectionEntity> getCollections(CollectionsReadOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getCollectionsRequest(options), this.getCollectionsResponseDeserializer());
    }

    public IndexEntity getIndex(String id) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).validateIndexId(id);
        String[] split = id.split("/");
        return this.collection(split[0]).getIndex(split[1]);
    }

    public String deleteIndex(String id) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).validateIndexId(id);
        String[] split = id.split("/");
        return this.collection(split[0]).deleteIndex(split[1]);
    }

    public Boolean drop() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.dropRequest(), this.createDropResponseDeserializer());
    }

    public void grantAccess(String user, Permissions permissions) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.grantAccessRequest(user, permissions), (java.lang.reflect.Type)((Object)Void.class));
    }

    public void grantAccess(String user) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.grantAccessRequest(user, Permissions.RW), (java.lang.reflect.Type)((Object)Void.class));
    }

    public void revokeAccess(String user) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.grantAccessRequest(user, Permissions.NONE), (java.lang.reflect.Type)((Object)Void.class));
    }

    public void resetAccess(String user) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.resetAccessRequest(user), (java.lang.reflect.Type)((Object)Void.class));
    }

    public void updateUserDefaultCollectionAccess(String user, Permissions permissions) {
        ((ArangoExecutorSync)this.executor).execute(this.updateUserDefaultCollectionAccessRequest(user, permissions), (java.lang.reflect.Type)((Object)Void.class));
    }

    public <T> ArangoCursor<T> query(String query, Map<String, Object> bindVars, AqlQueryOptions options, Class<T> type) throws ArangoDBException {
        Request request = this.queryRequest(query, bindVars, options);
        CursorEntity result = (CursorEntity)((ArangoExecutorSync)this.executor).execute(request, (java.lang.reflect.Type)((Object)CursorEntity.class));
        return this.createCursor(result, type);
    }

    public <T> ArangoCursor<T> cursor(String cursorId, Class<T> type) throws ArangoDBException {
        CursorEntity result = (CursorEntity)((ArangoExecutorSync)this.executor).execute(this.queryNextRequest(cursorId), (java.lang.reflect.Type)((Object)CursorEntity.class));
        return this.createCursor(result, type);
    }

    private <T> ArangoCursor<T> createCursor(CursorEntity result, Class<T> type) {
        ArangoCursorExecute execute = new ArangoCursorExecute(){

            @Override
            public CursorEntity next(String id) {
                return (CursorEntity)((ArangoExecutorSync)ArangoDatabase.this.executor).execute(ArangoDatabase.this.queryNextRequest(id), (java.lang.reflect.Type)((Object)CursorEntity.class));
            }

            @Override
            public void close(String id) {
                ((ArangoExecutorSync)ArangoDatabase.this.executor).execute(ArangoDatabase.this.queryCloseRequest(id), (java.lang.reflect.Type)((Object)Void.class));
            }
        };
        return this.cursorInitializer != null ? this.cursorInitializer.createInstance(this, execute, type, result) : new ArangoCursor<T>(this, execute, type, result);
    }

    public AqlExecutionExplainEntity explainQuery(String query, Map<String, Object> bindVars, AqlQueryExplainOptions options) throws ArangoDBException {
        return (AqlExecutionExplainEntity)((ArangoExecutorSync)this.executor).execute(this.explainQueryRequest(query, bindVars, options), (java.lang.reflect.Type)((Object)AqlExecutionExplainEntity.class));
    }

    public AqlParseEntity parseQuery(String query) throws ArangoDBException {
        return (AqlParseEntity)((ArangoExecutorSync)this.executor).execute(this.parseQueryRequest(query), (java.lang.reflect.Type)((Object)AqlParseEntity.class));
    }

    public void clearQueryCache() throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.clearQueryCacheRequest(), (java.lang.reflect.Type)((Object)Void.class));
    }

    public QueryCachePropertiesEntity getQueryCacheProperties() throws ArangoDBException {
        return (QueryCachePropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.getQueryCachePropertiesRequest(), (java.lang.reflect.Type)((Object)QueryCachePropertiesEntity.class));
    }

    public QueryCachePropertiesEntity setQueryCacheProperties(QueryCachePropertiesEntity properties) throws ArangoDBException {
        return (QueryCachePropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.setQueryCachePropertiesRequest(properties), (java.lang.reflect.Type)((Object)QueryCachePropertiesEntity.class));
    }

    public QueryTrackingPropertiesEntity getQueryTrackingProperties() throws ArangoDBException {
        return (QueryTrackingPropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.getQueryTrackingPropertiesRequest(), (java.lang.reflect.Type)((Object)QueryTrackingPropertiesEntity.class));
    }

    public QueryTrackingPropertiesEntity setQueryTrackingProperties(QueryTrackingPropertiesEntity properties) throws ArangoDBException {
        return (QueryTrackingPropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.setQueryTrackingPropertiesRequest(properties), (java.lang.reflect.Type)((Object)QueryTrackingPropertiesEntity.class));
    }

    public Collection<QueryEntity> getCurrentlyRunningQueries() throws ArangoDBException {
        return (Collection)((ArangoExecutorSync)this.executor).execute(this.getCurrentlyRunningQueriesRequest(), new Type<Collection<QueryEntity>>(){}.getType());
    }

    public Collection<QueryEntity> getSlowQueries() throws ArangoDBException {
        return (Collection)((ArangoExecutorSync)this.executor).execute(this.getSlowQueriesRequest(), new Type<Collection<QueryEntity>>(){}.getType());
    }

    public void clearSlowQueries() throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.clearSlowQueriesRequest(), (java.lang.reflect.Type)((Object)Void.class));
    }

    public void killQuery(String id) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.killQueryRequest(id), (java.lang.reflect.Type)((Object)Void.class));
    }

    public void createAqlFunction(String name, String code, AqlFunctionCreateOptions options) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.createAqlFunctionRequest(name, code, options), (java.lang.reflect.Type)((Object)Void.class));
    }

    public void deleteAqlFunction(String name, AqlFunctionDeleteOptions options) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.deleteAqlFunctionRequest(name, options), (java.lang.reflect.Type)((Object)Void.class));
    }

    public Collection<AqlFunctionEntity> getAqlFunctions(AqlFunctionGetOptions options) throws ArangoDBException {
        return (Collection)((ArangoExecutorSync)this.executor).execute(this.getAqlFunctionsRequest(options), new Type<Collection<AqlFunctionEntity>>(){}.getType());
    }

    public ArangoGraph graph(String name) {
        return new ArangoGraph(this, name);
    }

    public GraphEntity createGraph(String name, Collection<EdgeDefinition> edgeDefinitions) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.createGraphRequest(name, edgeDefinitions, new GraphCreateOptions()), this.createGraphResponseDeserializer());
    }

    public GraphEntity createGraph(String name, Collection<EdgeDefinition> edgeDefinitions, GraphCreateOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.createGraphRequest(name, edgeDefinitions, options), this.createGraphResponseDeserializer());
    }

    public Collection<GraphEntity> getGraphs() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getGraphsRequest(), this.getGraphsResponseDeserializer());
    }

    public <T> T transaction(String action, Class<T> type, TransactionOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.transactionRequest(action, options), this.transactionResponseDeserializer(type));
    }

    public DatabaseEntity getInfo() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getInfoRequest(), this.getInfoResponseDeserializer());
    }

    public <V, E> TraversalEntity<V, E> executeTraversal(Class<V> vertexClass, Class<E> edgeClass, TraversalOptions options) throws ArangoDBException {
        Request request = this.executeTraversalRequest(options);
        return ((ArangoExecutorSync)this.executor).execute(request, this.executeTraversalResponseDeserializer(vertexClass, edgeClass));
    }

    public <T> T getDocument(String id, Class<T> type) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).validateDocumentId(id);
        String[] split = id.split("/");
        return this.collection(split[0]).getDocument(split[1], type);
    }

    public <T> T getDocument(String id, Class<T> type, DocumentReadOptions options) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).validateDocumentId(id);
        String[] split = id.split("/");
        return this.collection(split[0]).getDocument(split[1], type, options);
    }

    public void reloadRouting() throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.reloadRoutingRequest(), (java.lang.reflect.Type)((Object)Void.class));
    }

    protected ArangoDatabase setCursorInitializer(ArangoCursorInitializer cursorInitializer) {
        this.cursorInitializer = cursorInitializer;
        return this;
    }
}

