/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabase;
import com.arangodb.Protocol;
import com.arangodb.entity.ArangoDBVersion;
import com.arangodb.entity.LogEntity;
import com.arangodb.entity.LogLevelEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.ServerRole;
import com.arangodb.entity.UserEntity;
import com.arangodb.internal.ArangoDBConstants;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.CollectionCache;
import com.arangodb.internal.CommunicationProtocol;
import com.arangodb.internal.DefaultHostHandler;
import com.arangodb.internal.DocumentCache;
import com.arangodb.internal.Host;
import com.arangodb.internal.InternalArangoDB;
import com.arangodb.internal.http.HttpCommunication;
import com.arangodb.internal.http.HttpProtocol;
import com.arangodb.internal.util.ArangoDeserializerImpl;
import com.arangodb.internal.util.ArangoSerializerImpl;
import com.arangodb.internal.util.ArangoUtilImpl;
import com.arangodb.internal.velocypack.VPackDocumentModule;
import com.arangodb.internal.velocypack.VPackDriverModule;
import com.arangodb.internal.velocystream.VstCommunicationSync;
import com.arangodb.internal.velocystream.VstProtocol;
import com.arangodb.internal.velocystream.internal.ConnectionSync;
import com.arangodb.model.LogOptions;
import com.arangodb.model.UserCreateOptions;
import com.arangodb.model.UserUpdateOptions;
import com.arangodb.util.ArangoCursorInitializer;
import com.arangodb.util.ArangoDeserializer;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.util.ArangoSerializer;
import com.arangodb.velocypack.VPack;
import com.arangodb.velocypack.VPackAnnotationFieldFilter;
import com.arangodb.velocypack.VPackAnnotationFieldNaming;
import com.arangodb.velocypack.VPackDeserializer;
import com.arangodb.velocypack.VPackInstanceCreator;
import com.arangodb.velocypack.VPackJsonDeserializer;
import com.arangodb.velocypack.VPackJsonSerializer;
import com.arangodb.velocypack.VPackModule;
import com.arangodb.velocypack.VPackParser;
import com.arangodb.velocypack.VPackParserModule;
import com.arangodb.velocypack.VPackSerializer;
import com.arangodb.velocypack.ValueType;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.Response;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.SSLContext;

public class ArangoDB
extends InternalArangoDB<ArangoExecutorSync, Response, ConnectionSync> {
    private ArangoCursorInitializer cursorInitializer;

    public ArangoDB(VstCommunicationSync.Builder vstBuilder, HttpCommunication.Builder httpBuilder, final ArangoSerialization util, CollectionCache collectionCache, Protocol protocol) {
        super(new ArangoExecutorSync(ArangoDB.createProtocol(vstBuilder, httpBuilder, util, collectionCache, protocol), util, new DocumentCache()), util);
        final CommunicationProtocol cp = ArangoDB.createProtocol(vstBuilder, httpBuilder, util, collectionCache, protocol);
        collectionCache.init(new CollectionCache.DBAccess(){

            @Override
            public ArangoDatabase db(String name) {
                return new ArangoDatabase(cp, util, ((ArangoExecutorSync)ArangoDB.this.executor).documentCache(), name).setCursorInitializer(ArangoDB.this.cursorInitializer);
            }
        });
    }

    private static CommunicationProtocol createProtocol(VstCommunicationSync.Builder vstBuilder, HttpCommunication.Builder httpBuilder, ArangoSerialization util, CollectionCache collectionCache, Protocol protocol) {
        return protocol == null || Protocol.VST == protocol ? ArangoDB.createVST(vstBuilder, util, collectionCache) : ArangoDB.createHTTP(httpBuilder, util);
    }

    private static CommunicationProtocol createVST(VstCommunicationSync.Builder builder, ArangoSerialization util, CollectionCache collectionCache) {
        return new VstProtocol(builder.build(util, collectionCache));
    }

    private static CommunicationProtocol createHTTP(HttpCommunication.Builder builder, ArangoSerialization util) {
        return new HttpProtocol(builder.build(util));
    }

    @Override
    protected ArangoExecutorSync executor() {
        return (ArangoExecutorSync)this.executor;
    }

    public void shutdown() {
        ((ArangoExecutorSync)this.executor).disconnect();
    }

    public ArangoDatabase db() {
        return this.db("_system");
    }

    public ArangoDatabase db(String name) {
        return new ArangoDatabase(this, name).setCursorInitializer(this.cursorInitializer);
    }

    public Boolean createDatabase(String name) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.createDatabaseRequest(name), this.createDatabaseResponseDeserializer());
    }

    public Collection<String> getDatabases() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getDatabasesRequest(this.db().name()), this.getDatabaseResponseDeserializer());
    }

    public Collection<String> getAccessibleDatabases() throws ArangoDBException {
        return this.db().getAccessibleDatabases();
    }

    public Collection<String> getAccessibleDatabasesFor(String user) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getAccessibleDatabasesForRequest(this.db().name(), user), this.getAccessibleDatabasesForResponseDeserializer());
    }

    public ArangoDBVersion getVersion() throws ArangoDBException {
        return this.db().getVersion();
    }

    public ServerRole getRole() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getRoleRequest(), this.getRoleResponseDeserializer());
    }

    public UserEntity createUser(String user, String passwd) throws ArangoDBException {
        return (UserEntity)((ArangoExecutorSync)this.executor).execute(this.createUserRequest(this.db().name(), user, passwd, new UserCreateOptions()), (Type)((Object)UserEntity.class));
    }

    public UserEntity createUser(String user, String passwd, UserCreateOptions options) throws ArangoDBException {
        return (UserEntity)((ArangoExecutorSync)this.executor).execute(this.createUserRequest(this.db().name(), user, passwd, options), (Type)((Object)UserEntity.class));
    }

    public void deleteUser(String user) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.deleteUserRequest(this.db().name(), user), (Type)((Object)Void.class));
    }

    public UserEntity getUser(String user) throws ArangoDBException {
        return (UserEntity)((ArangoExecutorSync)this.executor).execute(this.getUserRequest(this.db().name(), user), (Type)((Object)UserEntity.class));
    }

    public Collection<UserEntity> getUsers() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getUsersRequest(this.db().name()), this.getUsersResponseDeserializer());
    }

    public UserEntity updateUser(String user, UserUpdateOptions options) throws ArangoDBException {
        return (UserEntity)((ArangoExecutorSync)this.executor).execute(this.updateUserRequest(this.db().name(), user, options), (Type)((Object)UserEntity.class));
    }

    public UserEntity replaceUser(String user, UserUpdateOptions options) throws ArangoDBException {
        return (UserEntity)((ArangoExecutorSync)this.executor).execute(this.replaceUserRequest(this.db().name(), user, options), (Type)((Object)UserEntity.class));
    }

    public void updateUserDefaultDatabaseAccess(String user, Permissions permissions) {
        ((ArangoExecutorSync)this.executor).execute(this.updateUserDefaultDatabaseAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    public void updateUserDefaultCollectionAccess(String user, Permissions permissions) {
        ((ArangoExecutorSync)this.executor).execute(this.updateUserDefaultCollectionAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    public Response execute(Request request) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(request, new ArangoExecutor.ResponseDeserializer<Response>(){

            @Override
            public Response deserialize(Response response) throws VPackException {
                return response;
            }
        });
    }

    public LogEntity getLogs(LogOptions options) throws ArangoDBException {
        return (LogEntity)((ArangoExecutorSync)this.executor).execute(this.getLogsRequest(options), (Type)((Object)LogEntity.class));
    }

    public LogLevelEntity getLogLevel() throws ArangoDBException {
        return (LogLevelEntity)((ArangoExecutorSync)this.executor).execute(this.getLogLevelRequest(), (Type)((Object)LogLevelEntity.class));
    }

    public LogLevelEntity setLogLevel(LogLevelEntity entity) throws ArangoDBException {
        return (LogLevelEntity)((ArangoExecutorSync)this.executor).execute(this.setLogLevelRequest(entity), (Type)((Object)LogLevelEntity.class));
    }

    public ArangoDB _setCursorInitializer(ArangoCursorInitializer cursorInitializer) {
        this.cursorInitializer = cursorInitializer;
        return this;
    }

    public static class Builder {
        private final List<Host> hosts;
        private Host host;
        private Integer timeout;
        private String user;
        private String password;
        private Boolean useSsl;
        private SSLContext sslContext;
        private Integer chunksize;
        private Integer maxConnections;
        private final VPack.Builder vpackBuilder = new VPack.Builder();
        private final VPackParser.Builder vpackParserBuilder = new VPackParser.Builder();
        private ArangoSerializer serializer;
        private ArangoDeserializer deserializer;
        private Protocol protocol;

        public Builder() {
            this.vpackBuilder.registerModule((VPackModule)new VPackDriverModule());
            this.vpackParserBuilder.registerModule((VPackParserModule)new VPackDriverModule());
            this.host = new Host("127.0.0.1", ArangoDBConstants.DEFAULT_PORT);
            this.hosts = new ArrayList<Host>();
            this.user = "root";
            this.loadProperties(ArangoDB.class.getResourceAsStream("/arangodb.properties"));
        }

        public Builder loadProperties(InputStream in) throws ArangoDBException {
            if (in != null) {
                Properties properties = new Properties();
                try {
                    properties.load(in);
                    ArangoDB.loadHosts(properties, this.hosts);
                    String host = ArangoDB.loadHost(properties, this.host.getHost());
                    int port = ArangoDB.loadPort(properties, this.host.getPort());
                    this.host = new Host(host, port);
                    this.timeout = ArangoDB.loadTimeout(properties, this.timeout);
                    this.user = ArangoDB.loadUser(properties, this.user);
                    this.password = ArangoDB.loadPassword(properties, this.password);
                    this.useSsl = ArangoDB.loadUseSsl(properties, this.useSsl);
                    this.chunksize = ArangoDB.loadChunkSize(properties, this.chunksize);
                    this.maxConnections = ArangoDB.loadMaxConnections(properties, this.maxConnections);
                    this.protocol = ArangoDB.loadProtocol(properties, this.protocol);
                }
                catch (IOException e) {
                    throw new ArangoDBException(e);
                }
            }
            return this;
        }

        @Deprecated
        public Builder host(String host) {
            this.host = new Host(host, this.host.getPort());
            return this;
        }

        @Deprecated
        public Builder port(Integer port) {
            this.host = new Host(this.host.getHost(), port);
            return this;
        }

        public Builder host(String host, int port) {
            this.hosts.add(new Host(host, port));
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder useSsl(Boolean useSsl) {
            this.useSsl = useSsl;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder chunksize(Integer chunksize) {
            this.chunksize = chunksize;
            return this;
        }

        public Builder maxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder useProtocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public <T> Builder registerSerializer(Class<T> clazz, VPackSerializer<T> serializer) {
            this.vpackBuilder.registerSerializer(clazz, serializer);
            return this;
        }

        public <T> Builder registerEnclosingSerializer(Class<T> clazz, VPackSerializer<T> serializer) {
            this.vpackBuilder.registerEnclosingSerializer(clazz, serializer);
            return this;
        }

        public <T> Builder registerDeserializer(Class<T> clazz, VPackDeserializer<T> deserializer) {
            this.vpackBuilder.registerDeserializer(clazz, deserializer);
            return this;
        }

        public <T> Builder registerInstanceCreator(Class<T> clazz, VPackInstanceCreator<T> creator) {
            this.vpackBuilder.registerInstanceCreator(clazz, creator);
            return this;
        }

        public Builder registerJsonDeserializer(ValueType type, VPackJsonDeserializer deserializer) {
            this.vpackParserBuilder.registerDeserializer(type, deserializer);
            return this;
        }

        public Builder registerJsonDeserializer(String attribute, ValueType type, VPackJsonDeserializer deserializer) {
            this.vpackParserBuilder.registerDeserializer(attribute, type, deserializer);
            return this;
        }

        public <T> Builder registerJsonSerializer(Class<T> clazz, VPackJsonSerializer<T> serializer) {
            this.vpackParserBuilder.registerSerializer(clazz, serializer);
            return this;
        }

        public <T> Builder registerJsonSerializer(String attribute, Class<T> clazz, VPackJsonSerializer<T> serializer) {
            this.vpackParserBuilder.registerSerializer(attribute, clazz, serializer);
            return this;
        }

        public <A extends Annotation> Builder annotationFieldFilter(Class<A> type, VPackAnnotationFieldFilter<A> fieldFilter) {
            this.vpackBuilder.annotationFieldFilter(type, fieldFilter);
            return this;
        }

        public <A extends Annotation> Builder annotationFieldNaming(Class<A> type, VPackAnnotationFieldNaming<A> fieldNaming) {
            this.vpackBuilder.annotationFieldNaming(type, fieldNaming);
            return this;
        }

        public Builder registerModule(VPackModule module) {
            this.vpackBuilder.registerModule(module);
            return this;
        }

        public Builder registerModules(VPackModule ... modules) {
            this.vpackBuilder.registerModules(modules);
            return this;
        }

        public Builder registerJsonModule(VPackParserModule module) {
            this.vpackParserBuilder.registerModule(module);
            return this;
        }

        public Builder registerJsonModules(VPackParserModule ... module) {
            this.vpackParserBuilder.registerModules(module);
            return this;
        }

        public Builder setSerializer(ArangoSerializer serializer) {
            this.serializer = serializer;
            return this;
        }

        public Builder setDeserializer(ArangoDeserializer deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        public synchronized ArangoDB build() {
            if (this.hosts.isEmpty()) {
                this.hosts.add(this.host);
            }
            CollectionCache collectionCache = new CollectionCache();
            this.vpackBuilder.registerModule((VPackModule)new VPackDocumentModule(collectionCache));
            this.vpackParserBuilder.registerModule((VPackParserModule)new VPackDocumentModule(collectionCache));
            VPack vpacker = this.vpackBuilder.serializeNullValues(false).build();
            VPack vpackerNull = this.vpackBuilder.serializeNullValues(true).build();
            VPackParser vpackParser = this.vpackParserBuilder.build();
            ArangoSerializer serializerTemp = this.serializer != null ? this.serializer : new ArangoSerializerImpl(vpacker, vpackerNull, vpackParser);
            ArangoDeserializer deserializerTemp = this.deserializer != null ? this.deserializer : new ArangoDeserializerImpl(vpackerNull, vpackParser);
            return new ArangoDB(new VstCommunicationSync.Builder(new DefaultHostHandler(new ArrayList<Host>(this.hosts))).timeout(this.timeout).user(this.user).password(this.password).useSsl(this.useSsl).sslContext(this.sslContext).chunksize(this.chunksize).maxConnections(this.maxConnections), new HttpCommunication.Builder(new DefaultHostHandler(new ArrayList<Host>(this.hosts)), this.protocol).timeout(this.timeout).user(this.user).password(this.password).useSsl(this.useSsl).sslContext(this.sslContext).maxConnections(this.maxConnections), new ArangoUtilImpl(serializerTemp, deserializerTemp), collectionCache, this.protocol);
        }
    }
}

