/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb;

import com.arangodb.entity.CursorEntity;
import com.arangodb.internal.ArangoCursorExecute;
import com.arangodb.internal.ArangoCursorIterator;
import com.arangodb.internal.InternalArangoDatabase;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ArangoCursor<T>
implements Iterator<T>,
Closeable {
    private final Class<T> type;
    protected final ArangoCursorIterator<T> iterator;
    private final String id;
    private final ArangoCursorExecute execute;

    protected ArangoCursor(InternalArangoDatabase<?, ?, ?, ?> db, ArangoCursorExecute execute, Class<T> type, CursorEntity result) {
        this.execute = execute;
        this.type = type;
        this.iterator = this.createIterator(this, db, execute, result);
        this.id = result.getId();
    }

    protected ArangoCursorIterator<T> createIterator(ArangoCursor<T> cursor, InternalArangoDatabase<?, ?, ?, ?> db, ArangoCursorExecute execute, CursorEntity result) {
        return new ArangoCursorIterator<T>(cursor, execute, db, result);
    }

    public String getId() {
        return this.id;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Integer getCount() {
        return this.iterator.getResult().getCount();
    }

    public CursorEntity.Stats getStats() {
        CursorEntity.Extras extra = this.iterator.getResult().getExtra();
        return extra != null ? extra.getStats() : null;
    }

    public Collection<CursorEntity.Warning> getWarnings() {
        CursorEntity.Extras extra = this.iterator.getResult().getExtra();
        return extra != null ? extra.getWarnings() : null;
    }

    public boolean isCached() {
        Boolean cached = this.iterator.getResult().getCached();
        return cached != null && cached != false;
    }

    @Override
    public void close() throws IOException {
        if (this.id != null) {
            this.execute.close(this.id);
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return this.iterator.next();
    }

    public List<T> asListRemaining() {
        ArrayList<T> remaining = new ArrayList<T>();
        while (this.hasNext()) {
            remaining.add(this.next());
        }
        return remaining;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

