/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb;

import com.arangodb.ArangoDB;
import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabase;
import com.arangodb.entity.CollectionEntity;
import com.arangodb.entity.CollectionPropertiesEntity;
import com.arangodb.entity.CollectionRevisionEntity;
import com.arangodb.entity.DocumentCreateEntity;
import com.arangodb.entity.DocumentDeleteEntity;
import com.arangodb.entity.DocumentImportEntity;
import com.arangodb.entity.DocumentUpdateEntity;
import com.arangodb.entity.IndexEntity;
import com.arangodb.entity.MultiDocumentEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.InternalArangoCollection;
import com.arangodb.internal.velocystream.internal.ConnectionSync;
import com.arangodb.model.CollectionPropertiesOptions;
import com.arangodb.model.DocumentCreateOptions;
import com.arangodb.model.DocumentDeleteOptions;
import com.arangodb.model.DocumentExistsOptions;
import com.arangodb.model.DocumentImportOptions;
import com.arangodb.model.DocumentReadOptions;
import com.arangodb.model.DocumentReplaceOptions;
import com.arangodb.model.DocumentUpdateOptions;
import com.arangodb.model.FulltextIndexOptions;
import com.arangodb.model.GeoIndexOptions;
import com.arangodb.model.HashIndexOptions;
import com.arangodb.model.PersistentIndexOptions;
import com.arangodb.model.SkiplistIndexOptions;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocystream.Response;
import java.lang.reflect.Type;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArangoCollection
extends InternalArangoCollection<ArangoDB, ArangoDatabase, ArangoExecutorSync, Response, ConnectionSync> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArangoCollection.class);

    protected ArangoCollection(ArangoDatabase db, String name) {
        super(db, name);
    }

    public <T> DocumentCreateEntity<T> insertDocument(T value) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.insertDocumentRequest(value, new DocumentCreateOptions()), this.insertDocumentResponseDeserializer(value));
    }

    public <T> DocumentCreateEntity<T> insertDocument(T value, DocumentCreateOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.insertDocumentRequest(value, options), this.insertDocumentResponseDeserializer(value));
    }

    public <T> MultiDocumentEntity<DocumentCreateEntity<T>> insertDocuments(Collection<T> values) throws ArangoDBException {
        DocumentCreateOptions params = new DocumentCreateOptions();
        return ((ArangoExecutorSync)this.executor).execute(this.insertDocumentsRequest(values, params), this.insertDocumentsResponseDeserializer(values, params));
    }

    public <T> MultiDocumentEntity<DocumentCreateEntity<T>> insertDocuments(Collection<T> values, DocumentCreateOptions options) throws ArangoDBException {
        DocumentCreateOptions params = options != null ? options : new DocumentCreateOptions();
        return ((ArangoExecutorSync)this.executor).execute(this.insertDocumentsRequest(values, params), this.insertDocumentsResponseDeserializer(values, params));
    }

    public DocumentImportEntity importDocuments(Collection<?> values) throws ArangoDBException {
        return this.importDocuments(values, new DocumentImportOptions());
    }

    public DocumentImportEntity importDocuments(Collection<?> values, DocumentImportOptions options) throws ArangoDBException {
        return (DocumentImportEntity)((ArangoExecutorSync)this.executor).execute(this.importDocumentsRequest(values, options), (Type)((Object)DocumentImportEntity.class));
    }

    public DocumentImportEntity importDocuments(String values) throws ArangoDBException {
        return (DocumentImportEntity)((ArangoExecutorSync)this.executor).execute(this.importDocumentsRequest(values, new DocumentImportOptions()), (Type)((Object)DocumentImportEntity.class));
    }

    public DocumentImportEntity importDocuments(String values, DocumentImportOptions options) throws ArangoDBException {
        return (DocumentImportEntity)((ArangoExecutorSync)this.executor).execute(this.importDocumentsRequest(values, options), (Type)((Object)DocumentImportEntity.class));
    }

    public <T> T getDocument(String key, Class<T> type) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).validateDocumentKey(key);
        try {
            return ((ArangoExecutorSync)this.executor).execute(this.getDocumentRequest(key, new DocumentReadOptions()), type);
        }
        catch (ArangoDBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public <T> T getDocument(String key, Class<T> type, DocumentReadOptions options) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).validateDocumentKey(key);
        try {
            return ((ArangoExecutorSync)this.executor).execute(this.getDocumentRequest(key, options), type);
        }
        catch (ArangoDBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            if (!(e.getResponseCode() == null || e.getResponseCode() != 404 && e.getResponseCode() != 304 && e.getResponseCode() != 412 || options != null && !options.isCatchException())) {
                return null;
            }
            throw e;
        }
    }

    public <T> MultiDocumentEntity<T> getDocuments(Collection<String> keys, Class<T> type) throws ArangoDBException {
        DocumentReadOptions options = new DocumentReadOptions();
        return ((ArangoExecutorSync)this.executor).execute(this.getDocumentsRequest(keys, options), this.getDocumentsResponseDeserializer(type, options));
    }

    public <T> DocumentUpdateEntity<T> replaceDocument(String key, T value) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.replaceDocumentRequest(key, value, new DocumentReplaceOptions()), this.replaceDocumentResponseDeserializer(value));
    }

    public <T> DocumentUpdateEntity<T> replaceDocument(String key, T value, DocumentReplaceOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.replaceDocumentRequest(key, value, options), this.replaceDocumentResponseDeserializer(value));
    }

    public <T> MultiDocumentEntity<DocumentUpdateEntity<T>> replaceDocuments(Collection<T> values) throws ArangoDBException {
        DocumentReplaceOptions params = new DocumentReplaceOptions();
        return ((ArangoExecutorSync)this.executor).execute(this.replaceDocumentsRequest(values, params), this.replaceDocumentsResponseDeserializer(values, params));
    }

    public <T> MultiDocumentEntity<DocumentUpdateEntity<T>> replaceDocuments(Collection<T> values, DocumentReplaceOptions options) throws ArangoDBException {
        DocumentReplaceOptions params = options != null ? options : new DocumentReplaceOptions();
        return ((ArangoExecutorSync)this.executor).execute(this.replaceDocumentsRequest(values, params), this.replaceDocumentsResponseDeserializer(values, params));
    }

    public <T> DocumentUpdateEntity<T> updateDocument(String key, T value) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.updateDocumentRequest(key, value, new DocumentUpdateOptions()), this.updateDocumentResponseDeserializer(value));
    }

    public <T> DocumentUpdateEntity<T> updateDocument(String key, T value, DocumentUpdateOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.updateDocumentRequest(key, value, options), this.updateDocumentResponseDeserializer(value));
    }

    public <T> MultiDocumentEntity<DocumentUpdateEntity<T>> updateDocuments(Collection<T> values) throws ArangoDBException {
        DocumentUpdateOptions params = new DocumentUpdateOptions();
        return ((ArangoExecutorSync)this.executor).execute(this.updateDocumentsRequest(values, params), this.updateDocumentsResponseDeserializer(values, params));
    }

    public <T> MultiDocumentEntity<DocumentUpdateEntity<T>> updateDocuments(Collection<T> values, DocumentUpdateOptions options) throws ArangoDBException {
        DocumentUpdateOptions params = options != null ? options : new DocumentUpdateOptions();
        return ((ArangoExecutorSync)this.executor).execute(this.updateDocumentsRequest(values, params), this.updateDocumentsResponseDeserializer(values, params));
    }

    public DocumentDeleteEntity<Void> deleteDocument(String key) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.deleteDocumentRequest(key, new DocumentDeleteOptions()), this.deleteDocumentResponseDeserializer(Void.class));
    }

    public <T> DocumentDeleteEntity<T> deleteDocument(String key, Class<T> type, DocumentDeleteOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.deleteDocumentRequest(key, options), this.deleteDocumentResponseDeserializer(type));
    }

    public MultiDocumentEntity<DocumentDeleteEntity<Void>> deleteDocuments(Collection<?> values) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.deleteDocumentsRequest(values, new DocumentDeleteOptions()), this.deleteDocumentsResponseDeserializer(Void.class));
    }

    public <T> MultiDocumentEntity<DocumentDeleteEntity<T>> deleteDocuments(Collection<?> values, Class<T> type, DocumentDeleteOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.deleteDocumentsRequest(values, options), this.deleteDocumentsResponseDeserializer(type));
    }

    public Boolean documentExists(String key) {
        return this.documentExists(key, new DocumentExistsOptions());
    }

    public Boolean documentExists(String key, DocumentExistsOptions options) throws ArangoDBException {
        try {
            ((ArangoExecutorSync)this.executor).execute(this.documentExistsRequest(key, options), (Type)((Object)VPackSlice.class));
            return true;
        }
        catch (ArangoDBException e) {
            if (!(e.getResponseCode() == null || e.getResponseCode() != 404 && e.getResponseCode() != 304 && e.getResponseCode() != 412 || options != null && !options.isCatchException())) {
                return false;
            }
            throw e;
        }
    }

    public IndexEntity getIndex(String id) throws ArangoDBException {
        return (IndexEntity)((ArangoExecutorSync)this.executor).execute(this.getIndexRequest(id), (Type)((Object)IndexEntity.class));
    }

    public String deleteIndex(String id) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.deleteIndexRequest(id), this.deleteIndexResponseDeserializer());
    }

    public IndexEntity createHashIndex(Collection<String> fields, HashIndexOptions options) throws ArangoDBException {
        return (IndexEntity)((ArangoExecutorSync)this.executor).execute(this.createHashIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    public IndexEntity createSkiplistIndex(Collection<String> fields, SkiplistIndexOptions options) throws ArangoDBException {
        return (IndexEntity)((ArangoExecutorSync)this.executor).execute(this.createSkiplistIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    public IndexEntity createPersistentIndex(Collection<String> fields, PersistentIndexOptions options) throws ArangoDBException {
        return (IndexEntity)((ArangoExecutorSync)this.executor).execute(this.createPersistentIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    public IndexEntity createGeoIndex(Collection<String> fields, GeoIndexOptions options) throws ArangoDBException {
        return (IndexEntity)((ArangoExecutorSync)this.executor).execute(this.createGeoIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    public IndexEntity createFulltextIndex(Collection<String> fields, FulltextIndexOptions options) throws ArangoDBException {
        return (IndexEntity)((ArangoExecutorSync)this.executor).execute(this.createFulltextIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    public Collection<IndexEntity> getIndexes() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getIndexesRequest(), this.getIndexesResponseDeserializer());
    }

    public CollectionEntity truncate() throws ArangoDBException {
        return (CollectionEntity)((ArangoExecutorSync)this.executor).execute(this.truncateRequest(), (Type)((Object)CollectionEntity.class));
    }

    public CollectionPropertiesEntity count() throws ArangoDBException {
        return (CollectionPropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.countRequest(), (Type)((Object)CollectionPropertiesEntity.class));
    }

    public void drop() throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.dropRequest(null), (Type)((Object)Void.class));
    }

    public void drop(boolean isSystem) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.dropRequest(isSystem), (Type)((Object)Void.class));
    }

    public CollectionEntity load() throws ArangoDBException {
        return (CollectionEntity)((ArangoExecutorSync)this.executor).execute(this.loadRequest(), (Type)((Object)CollectionEntity.class));
    }

    public CollectionEntity unload() throws ArangoDBException {
        return (CollectionEntity)((ArangoExecutorSync)this.executor).execute(this.unloadRequest(), (Type)((Object)CollectionEntity.class));
    }

    public CollectionEntity getInfo() throws ArangoDBException {
        return (CollectionEntity)((ArangoExecutorSync)this.executor).execute(this.getInfoRequest(), (Type)((Object)CollectionEntity.class));
    }

    public CollectionPropertiesEntity getProperties() throws ArangoDBException {
        return (CollectionPropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.getPropertiesRequest(), (Type)((Object)CollectionPropertiesEntity.class));
    }

    public CollectionPropertiesEntity changeProperties(CollectionPropertiesOptions options) throws ArangoDBException {
        return (CollectionPropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.changePropertiesRequest(options), (Type)((Object)CollectionPropertiesEntity.class));
    }

    public CollectionEntity rename(String newName) throws ArangoDBException {
        return (CollectionEntity)((ArangoExecutorSync)this.executor).execute(this.renameRequest(newName), (Type)((Object)CollectionEntity.class));
    }

    public CollectionRevisionEntity getRevision() throws ArangoDBException {
        return (CollectionRevisionEntity)((ArangoExecutorSync)this.executor).execute(this.getRevisionRequest(), (Type)((Object)CollectionRevisionEntity.class));
    }

    public void grantAccess(String user, Permissions permissions) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.grantAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    public void revokeAccess(String user) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.grantAccessRequest(user, Permissions.NONE), (Type)((Object)Void.class));
    }

    public void resetAccess(String user) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.resetAccessRequest(user), (Type)((Object)Void.class));
    }
}

