/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.arakelian.jackson.com.google.common.collect;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import repackaged.com.arakelian.jackson.com.google.common.collect.ImmutableBiMap;
import repackaged.com.arakelian.jackson.com.google.common.collect.ImmutableList;
import repackaged.com.arakelian.jackson.com.google.common.collect.ImmutableMapEntry;
import repackaged.com.arakelian.jackson.com.google.common.collect.ImmutableMapEntrySet;
import repackaged.com.arakelian.jackson.com.google.common.collect.ImmutableMapKeySet;
import repackaged.com.arakelian.jackson.com.google.common.collect.ImmutableSet;
import repackaged.com.arakelian.jackson.com.google.common.collect.Maps;
import repackaged.com.arakelian.jackson.com.google.common.collect.RegularImmutableMap;

final class JdkBackedImmutableBiMap<K, V>
extends ImmutableBiMap<K, V> {
    private final transient ImmutableList<Map.Entry<K, V>> entries;
    private final Map<K, V> forwardDelegate;
    private final Map<V, K> backwardDelegate;
    private transient JdkBackedImmutableBiMap<V, K> inverse;

    static <K, V> ImmutableBiMap<K, V> create(int n, Map.Entry<K, V>[] entryArray) {
        HashMap forwardDelegate = Maps.newHashMapWithExpectedSize(n);
        HashMap backwardDelegate = Maps.newHashMapWithExpectedSize(n);
        for (int i = 0; i < n; ++i) {
            ImmutableMapEntry<K, V> e = RegularImmutableMap.makeImmutable(Objects.requireNonNull(entryArray[i]));
            entryArray[i] = e;
            Object oldValue = forwardDelegate.putIfAbsent(e.getKey(), e.getValue());
            if (oldValue != null) {
                String string = String.valueOf(e.getKey());
                String string2 = String.valueOf(oldValue);
                throw JdkBackedImmutableBiMap.conflictException("key", new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("=").append(string2).toString(), entryArray[i]);
            }
            Object oldKey = backwardDelegate.putIfAbsent(e.getValue(), e.getKey());
            if (oldKey == null) continue;
            String string = String.valueOf(oldKey);
            String string3 = String.valueOf(e.getValue());
            throw JdkBackedImmutableBiMap.conflictException("value", new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string3).length()).append(string).append("=").append(string3).toString(), entryArray[i]);
        }
        ImmutableList<Map.Entry<K, V>> entryList = ImmutableList.asImmutableList(entryArray, n);
        return new JdkBackedImmutableBiMap<K, V>(entryList, forwardDelegate, backwardDelegate);
    }

    private JdkBackedImmutableBiMap(ImmutableList<Map.Entry<K, V>> entries, Map<K, V> forwardDelegate, Map<V, K> backwardDelegate) {
        this.entries = entries;
        this.forwardDelegate = forwardDelegate;
        this.backwardDelegate = backwardDelegate;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public ImmutableBiMap<V, K> inverse() {
        JdkBackedImmutableBiMap<K, V> result = this.inverse;
        if (result == null) {
            this.inverse = result = new JdkBackedImmutableBiMap<K, V>(new InverseEntries(), this.backwardDelegate, this.forwardDelegate);
            result.inverse = this;
        }
        return result;
    }

    @Override
    public V get(Object key) {
        return this.forwardDelegate.get(key);
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    private final class InverseEntries
    extends ImmutableList<Map.Entry<V, K>> {
        private InverseEntries() {
        }

        @Override
        public Map.Entry<V, K> get(int index) {
            Map.Entry entry = (Map.Entry)JdkBackedImmutableBiMap.this.entries.get(index);
            return Maps.immutableEntry(entry.getValue(), entry.getKey());
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        public int size() {
            return JdkBackedImmutableBiMap.this.entries.size();
        }
    }
}

