/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.jackson.databind;

import com.arakelian.core.utils.MoreStringUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import java.io.IOException;

public final class EnumUppercaseDeserializerModifier
extends BeanDeserializerModifier {
    public JsonDeserializer<Enum> modifyEnumDeserializer(DeserializationConfig config, final JavaType type, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
        return new JsonDeserializer<Enum>(){

            public Enum deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                Class rawClass = type.getRawClass();
                String trimmed = MoreStringUtils.trimWhitespace((String)jp.getValueAsString());
                if (trimmed == null || trimmed.length() == 0) {
                    return null;
                }
                try {
                    return Enum.valueOf(rawClass, trimmed);
                }
                catch (IllegalArgumentException e) {
                    try {
                        return Enum.valueOf(rawClass, trimmed.toUpperCase());
                    }
                    catch (IllegalArgumentException e2) {
                        return Enum.valueOf(rawClass, trimmed.toLowerCase());
                    }
                }
            }
        };
    }
}

