/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.jackson;

import com.arakelian.jackson.AbstractMapPath;
import com.arakelian.jackson.ImmutableMapPath;
import com.arakelian.jackson.utils.JacksonUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Map;
import org.immutables.value.Value;
import repackaged.com.arakelian.jackson.org.apache.commons.lang3.StringUtils;

@JsonSerialize(using=MapPathSerializer.class, as=ImmutableMapPath.class)
@JsonDeserialize(builder=ImmutableMapPath.Builder.class)
@Value.Immutable
public abstract class MapPath
extends AbstractMapPath {
    private static final MapPath EMPTY = ImmutableMapPath.builder().build();

    public static MapPath of() {
        return EMPTY;
    }

    public static MapPath of(Map<?, ?> map) {
        return MapPath.of(map, null);
    }

    public static MapPath of(Map<?, ?> map, ObjectMapper mapper) {
        if (map == null || map.size() == 0) {
            return MapPath.of();
        }
        ImmutableMapPath mapPath = ImmutableMapPath.builder().putAllProperties(map).build();
        mapPath.setObjectMapper(mapper);
        return mapPath;
    }

    public static MapPath of(String json) throws IOException {
        if (StringUtils.isEmpty(json)) {
            return MapPath.of();
        }
        return MapPath.of(json, null);
    }

    public static MapPath of(String json, ObjectMapper mapper) throws IOException {
        if (StringUtils.isEmpty(json)) {
            return MapPath.of();
        }
        if (mapper == null) {
            mapper = JacksonUtils.getObjectMapper();
        }
        Map map = (Map)mapper.readValue(json, Map.class);
        ImmutableMapPath mapPath = ImmutableMapPath.builder().putAllProperties(map).build();
        mapPath.setObjectMapper(mapper);
        return mapPath;
    }

    public MapPath getMapPath(String path) {
        return MapPath.of(this.getMap(path), this.getObjectMapper());
    }

    public static class MapPathSerializer
    extends StdSerializer<MapPath> {
        public MapPathSerializer() {
            super(MapPath.class);
        }

        public boolean isEmpty(SerializerProvider provider, MapPath value) {
            return value == null || value.getProperties().isEmpty();
        }

        public void serialize(MapPath value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            Map<Object, Object> props = value.getProperties();
            provider.defaultSerializeValue(props, gen);
        }
    }
}

