/*
 * Decompiled with CFR 0.152.
 */
package com.appyvet.rangebar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.appyvet.rangebar.PinView;

public class ConnectingLine {
    private final Paint mPaint;
    private final float mY;

    public ConnectingLine(Context ctx, float y, float connectingLineWeight, int connectingLineColor) {
        Resources res = ctx.getResources();
        float connectingLineWeight1 = TypedValue.applyDimension((int)1, (float)connectingLineWeight, (DisplayMetrics)res.getDisplayMetrics());
        this.mPaint = new Paint();
        this.mPaint.setColor(connectingLineColor);
        this.mPaint.setStrokeWidth(connectingLineWeight1);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setAntiAlias(true);
        this.mY = y;
    }

    public void draw(Canvas canvas, PinView leftThumb, PinView rightThumb) {
        canvas.drawLine(leftThumb.getX(), this.mY, rightThumb.getX(), this.mY, this.mPaint);
    }

    public void draw(Canvas canvas, float leftMargin, PinView rightThumb) {
        canvas.drawLine(leftMargin, this.mY, rightThumb.getX(), this.mY, this.mPaint);
    }
}

