/*
 * Decompiled with CFR 0.152.
 */
package com.appyvet.rangebar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LightingColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import com.appyvet.rangebar.IRangeBarFormatter;
import com.appyvet.rangebar.R;

class PinView
extends View {
    private static final float MINIMUM_TARGET_RADIUS_DP = 24.0f;
    private static final float DEFAULT_THUMB_RADIUS_DP = 14.0f;
    private float mTargetRadiusPx;
    private boolean mIsPressed = false;
    private float mY;
    private float mX;
    private Paint mTextPaint;
    private Drawable mPin;
    private String mValue;
    private int mPinRadiusPx;
    private ColorFilter mPinFilter;
    private float mPinPadding;
    private float mTextYPadding;
    private Rect mBounds = new Rect();
    private Resources mRes;
    private float mDensity;
    private Paint mCirclePaint;
    private float mCircleRadiusPx;
    private IRangeBarFormatter formatter;
    private float mMinPinFont = 8.0f;
    private float mMaxPinFont = 24.0f;

    public PinView(Context context) {
        super(context);
    }

    public void setFormatter(IRangeBarFormatter mFormatter) {
        this.formatter = mFormatter;
    }

    public void init(Context ctx, float y, float pinRadiusDP, int pinColor, int textColor, float circleRadius, int circleColor, float minFont, float maxFont) {
        this.mRes = ctx.getResources();
        this.mPin = ContextCompat.getDrawable((Context)ctx, (int)R.drawable.rotate);
        this.mDensity = this.getResources().getDisplayMetrics().density;
        this.mMinPinFont = minFont / this.mDensity;
        this.mMaxPinFont = maxFont / this.mDensity;
        this.mPinPadding = (int)TypedValue.applyDimension((int)1, (float)15.0f, (DisplayMetrics)this.mRes.getDisplayMetrics());
        this.mCircleRadiusPx = circleRadius;
        this.mTextYPadding = (int)TypedValue.applyDimension((int)1, (float)3.5f, (DisplayMetrics)this.mRes.getDisplayMetrics());
        this.mPinRadiusPx = pinRadiusDP == -1.0f ? (int)TypedValue.applyDimension((int)1, (float)14.0f, (DisplayMetrics)this.mRes.getDisplayMetrics()) : (int)TypedValue.applyDimension((int)1, (float)pinRadiusDP, (DisplayMetrics)this.mRes.getDisplayMetrics());
        int textSize = (int)TypedValue.applyDimension((int)2, (float)15.0f, (DisplayMetrics)this.mRes.getDisplayMetrics());
        this.mTextPaint = new Paint();
        this.mTextPaint.setColor(textColor);
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setTextSize((float)textSize);
        this.mCirclePaint = new Paint();
        this.mCirclePaint.setColor(circleColor);
        this.mCirclePaint.setAntiAlias(true);
        this.mPinFilter = new LightingColorFilter(pinColor, pinColor);
        int targetRadius = (int)Math.max(24.0f, (float)this.mPinRadiusPx);
        this.mTargetRadiusPx = TypedValue.applyDimension((int)1, (float)targetRadius, (DisplayMetrics)this.mRes.getDisplayMetrics());
        this.mY = y;
    }

    public void setX(float x) {
        this.mX = x;
    }

    public float getX() {
        return this.mX;
    }

    public void setXValue(String x) {
        this.mValue = x;
    }

    public boolean isPressed() {
        return this.mIsPressed;
    }

    public void press() {
        this.mIsPressed = true;
    }

    public void setSize(float size, float padding) {
        this.mPinPadding = (int)padding;
        this.mPinRadiusPx = (int)size;
        this.invalidate();
    }

    public void release() {
        this.mIsPressed = false;
    }

    public boolean isInTargetZone(float x, float y) {
        return Math.abs(x - this.mX) <= this.mTargetRadiusPx && Math.abs(y - this.mY + this.mPinPadding) <= this.mTargetRadiusPx;
    }

    public void draw(Canvas canvas) {
        canvas.drawCircle(this.mX, this.mY, this.mCircleRadiusPx, this.mCirclePaint);
        if (this.mPinRadiusPx > 0) {
            this.mBounds.set((int)this.mX - this.mPinRadiusPx, (int)this.mY - this.mPinRadiusPx * 2 - (int)this.mPinPadding, (int)this.mX + this.mPinRadiusPx, (int)this.mY - (int)this.mPinPadding);
            this.mPin.setBounds(this.mBounds);
            String text = this.mValue;
            if (this.formatter != null) {
                text = this.formatter.format(text);
            }
            this.calibrateTextSize(this.mTextPaint, text, this.mBounds.width());
            this.mTextPaint.getTextBounds(text, 0, text.length(), this.mBounds);
            this.mTextPaint.setTextAlign(Paint.Align.CENTER);
            this.mPin.setColorFilter(this.mPinFilter);
            this.mPin.draw(canvas);
            canvas.drawText(text, this.mX, this.mY - (float)this.mPinRadiusPx - this.mPinPadding + this.mTextYPadding, this.mTextPaint);
        }
        super.draw(canvas);
    }

    private void calibrateTextSize(Paint paint, String text, float boxWidth) {
        paint.setTextSize(10.0f);
        float textSize = paint.measureText(text);
        float estimatedFontSize = boxWidth * 8.0f / textSize / this.mDensity;
        if (estimatedFontSize < this.mMinPinFont) {
            estimatedFontSize = this.mMinPinFont;
        } else if (estimatedFontSize > this.mMaxPinFont) {
            estimatedFontSize = this.mMaxPinFont;
        }
        Log.d((String)"pin", (String)("size = " + estimatedFontSize * this.mDensity));
        paint.setTextSize(estimatedFontSize * this.mDensity);
    }
}

