/*
 * Decompiled with CFR 0.152.
 */
package com.appyvet.rangebar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.appyvet.rangebar.PinView;

public class Bar {
    private final Paint mBarPaint;
    private final Paint mTickPaint;
    private final float mLeftX;
    private final float mRightX;
    private final float mY;
    private int mNumSegments;
    private float mTickDistance;
    private final float mTickHeight;

    public Bar(Context ctx, float x, float y, float length, int tickCount, float tickHeightDP, int tickColor, float barWeight, int barColor) {
        this.mLeftX = x;
        this.mRightX = x + length;
        this.mY = y;
        this.mNumSegments = tickCount - 1;
        this.mTickDistance = length / (float)this.mNumSegments;
        this.mTickHeight = TypedValue.applyDimension((int)1, (float)tickHeightDP, (DisplayMetrics)ctx.getResources().getDisplayMetrics());
        this.mBarPaint = new Paint();
        this.mBarPaint.setColor(barColor);
        this.mBarPaint.setStrokeWidth(barWeight);
        this.mBarPaint.setAntiAlias(true);
        this.mTickPaint = new Paint();
        this.mTickPaint.setColor(tickColor);
        this.mTickPaint.setStrokeWidth(barWeight);
        this.mTickPaint.setAntiAlias(true);
    }

    public void draw(Canvas canvas) {
        canvas.drawLine(this.mLeftX, this.mY, this.mRightX, this.mY, this.mBarPaint);
    }

    public float getLeftX() {
        return this.mLeftX;
    }

    public float getRightX() {
        return this.mRightX;
    }

    public float getNearestTickCoordinate(PinView thumb) {
        int nearestTickIndex = this.getNearestTickIndex(thumb);
        return this.mLeftX + (float)nearestTickIndex * this.mTickDistance;
    }

    public int getNearestTickIndex(PinView thumb) {
        return (int)((thumb.getX() - this.mLeftX + this.mTickDistance / 2.0f) / this.mTickDistance);
    }

    public void setTickCount(int tickCount) {
        float barLength = this.mRightX - this.mLeftX;
        this.mNumSegments = tickCount - 1;
        this.mTickDistance = barLength / (float)this.mNumSegments;
    }

    public void drawTicks(Canvas canvas) {
        for (int i = 0; i < this.mNumSegments; ++i) {
            float x = (float)i * this.mTickDistance + this.mLeftX;
            canvas.drawCircle(x, this.mY, this.mTickHeight, this.mTickPaint);
        }
        canvas.drawCircle(this.mRightX, this.mY, this.mTickHeight, this.mTickPaint);
    }
}

