/*
 * Decompiled with CFR 0.152.
 */
package timber.log;

import android.os.Build;
import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Timber {
    private static final Tree[] TREE_ARRAY_EMPTY = new Tree[0];
    private static final List<Tree> FOREST = new ArrayList<Tree>();
    static volatile Tree[] forestAsArray = TREE_ARRAY_EMPTY;
    private static final Tree TREE_OF_SOULS = new Tree(){

        @Override
        public void v(String message, Object ... args) {
            Tree[] forest;
            for (Tree tree : forest = forestAsArray) {
                tree.v(message, args);
            }
        }

        @Override
        public void v(Throwable t, String message, Object ... args) {
            Tree[] forest;
            for (Tree tree : forest = forestAsArray) {
                tree.v(t, message, args);
            }
        }

        @Override
        public void v(Throwable t) {
            Tree[] forest;
            for (Tree tree : forest = forestAsArray) {
                tree.v(t);
            }
        }

        @Override
        public void d(String message, Object ... args) {
            Tree[] forest;
            for (Tree tree : forest = forestAsArray) {
                tree.d(message, args);
            }
        }

        @Override
        public void d(Throwable t, String message, Object ... args) {
            Tree[] forest;
            for (Tree tree : forest = forestAsArray) {
                tree.d(t, message, args);
            }
        }

        @Override
        public void d(Throwable t) {
            Tree[] forest;
            for (Tree tree : forest = forestAsArray) {
                tree.d(t);
            }
        }

        @Override
        public void i(String message, Object ... args) {
            Tree[] forest;
            for (Tree tree : forest = forestAsArray) {
                tree.i(message, args);
            }
        }

        @Override
        public void i(Throwable t, String message, Object ... args) {
            Tree[] forest;
            for (Tree tree : forest = forestAsArray) {
                tree.i(t, message, args);
            }
        }

        @Override
        public void i(Throwable t) {
            Tree[] forest;
            for (Tree tree : forest = forestAsArray) {
                tree.i(t);
            }
        }

        @Override
        public void w(String message, Object ... args) {
            Tree[] forest;
            for (Tree tree : forest = forestAsArray) {
                tree.w(message, args);
            }
        }

        @Override
        public void w(Throwable t, String message, Object ... args) {
            Tree[] forest;
            for (Tree tree : forest = forestAsArray) {
                tree.w(t, message, args);
            }
        }

        @Override
        public void w(Throwable t) {
            Tree[] forest;
            for (Tree tree : forest = forestAsArray) {
                tree.w(t);
            }
        }

        @Override
        public void e(String message, Object ... args) {
            Tree[] forest;
            for (Tree tree : forest = forestAsArray) {
                tree.e(message, args);
            }
        }

        @Override
        public void e(Throwable t, String message, Object ... args) {
            Tree[] forest;
            for (Tree tree : forest = forestAsArray) {
                tree.e(t, message, args);
            }
        }

        @Override
        public void e(Throwable t) {
            Tree[] forest;
            for (Tree tree : forest = forestAsArray) {
                tree.e(t);
            }
        }

        @Override
        public void wtf(String message, Object ... args) {
            Tree[] forest;
            for (Tree tree : forest = forestAsArray) {
                tree.wtf(message, args);
            }
        }

        @Override
        public void wtf(Throwable t, String message, Object ... args) {
            Tree[] forest;
            for (Tree tree : forest = forestAsArray) {
                tree.wtf(t, message, args);
            }
        }

        @Override
        public void wtf(Throwable t) {
            Tree[] forest;
            for (Tree tree : forest = forestAsArray) {
                tree.wtf(t);
            }
        }

        @Override
        public void log(int priority, String message, Object ... args) {
            Tree[] forest;
            for (Tree tree : forest = forestAsArray) {
                tree.log(priority, message, args);
            }
        }

        @Override
        public void log(int priority, Throwable t, String message, Object ... args) {
            Tree[] forest;
            for (Tree tree : forest = forestAsArray) {
                tree.log(priority, t, message, args);
            }
        }

        @Override
        public void log(int priority, Throwable t) {
            Tree[] forest;
            for (Tree tree : forest = forestAsArray) {
                tree.log(priority, t);
            }
        }

        @Override
        protected void log(int priority, String tag, @NotNull String message, Throwable t) {
            throw new AssertionError((Object)"Missing override for log method.");
        }
    };

    public static void v(@NonNls String message, Object ... args) {
        TREE_OF_SOULS.v(message, args);
    }

    public static void v(Throwable t, @NonNls String message, Object ... args) {
        TREE_OF_SOULS.v(t, message, args);
    }

    public static void v(Throwable t) {
        TREE_OF_SOULS.v(t);
    }

    public static void d(@NonNls String message, Object ... args) {
        TREE_OF_SOULS.d(message, args);
    }

    public static void d(Throwable t, @NonNls String message, Object ... args) {
        TREE_OF_SOULS.d(t, message, args);
    }

    public static void d(Throwable t) {
        TREE_OF_SOULS.d(t);
    }

    public static void i(@NonNls String message, Object ... args) {
        TREE_OF_SOULS.i(message, args);
    }

    public static void i(Throwable t, @NonNls String message, Object ... args) {
        TREE_OF_SOULS.i(t, message, args);
    }

    public static void i(Throwable t) {
        TREE_OF_SOULS.i(t);
    }

    public static void w(@NonNls String message, Object ... args) {
        TREE_OF_SOULS.w(message, args);
    }

    public static void w(Throwable t, @NonNls String message, Object ... args) {
        TREE_OF_SOULS.w(t, message, args);
    }

    public static void w(Throwable t) {
        TREE_OF_SOULS.w(t);
    }

    public static void e(@NonNls String message, Object ... args) {
        TREE_OF_SOULS.e(message, args);
    }

    public static void e(Throwable t, @NonNls String message, Object ... args) {
        TREE_OF_SOULS.e(t, message, args);
    }

    public static void e(Throwable t) {
        TREE_OF_SOULS.e(t);
    }

    public static void wtf(@NonNls String message, Object ... args) {
        TREE_OF_SOULS.wtf(message, args);
    }

    public static void wtf(Throwable t, @NonNls String message, Object ... args) {
        TREE_OF_SOULS.wtf(t, message, args);
    }

    public static void wtf(Throwable t) {
        TREE_OF_SOULS.wtf(t);
    }

    public static void log(int priority, @NonNls String message, Object ... args) {
        TREE_OF_SOULS.log(priority, message, args);
    }

    public static void log(int priority, Throwable t, @NonNls String message, Object ... args) {
        TREE_OF_SOULS.log(priority, t, message, args);
    }

    public static void log(int priority, Throwable t) {
        TREE_OF_SOULS.log(priority, t);
    }

    @NotNull
    public static Tree asTree() {
        return TREE_OF_SOULS;
    }

    @NotNull
    public static Tree tag(String tag) {
        Tree[] forest;
        for (Tree tree : forest = forestAsArray) {
            tree.explicitTag.set(tag);
        }
        return TREE_OF_SOULS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void plant(@NotNull Tree tree) {
        if (tree == null) {
            throw new NullPointerException("tree == null");
        }
        if (tree == TREE_OF_SOULS) {
            throw new IllegalArgumentException("Cannot plant Timber into itself.");
        }
        List<Tree> list = FOREST;
        synchronized (list) {
            FOREST.add(tree);
            forestAsArray = FOREST.toArray(new Tree[FOREST.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void plant(Tree ... trees) {
        if (trees == null) {
            throw new NullPointerException("trees == null");
        }
        for (Tree tree : trees) {
            if (tree == null) {
                throw new NullPointerException("trees contains null");
            }
            if (tree != TREE_OF_SOULS) continue;
            throw new IllegalArgumentException("Cannot plant Timber into itself.");
        }
        List<Tree> list = FOREST;
        synchronized (list) {
            Collections.addAll(FOREST, trees);
            forestAsArray = FOREST.toArray(new Tree[FOREST.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uproot(@NotNull Tree tree) {
        List<Tree> list = FOREST;
        synchronized (list) {
            if (!FOREST.remove(tree)) {
                throw new IllegalArgumentException("Cannot uproot tree which is not planted: " + tree);
            }
            forestAsArray = FOREST.toArray(new Tree[FOREST.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uprootAll() {
        List<Tree> list = FOREST;
        synchronized (list) {
            FOREST.clear();
            forestAsArray = TREE_ARRAY_EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<Tree> forest() {
        List<Tree> list = FOREST;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Tree>(FOREST));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int treeCount() {
        List<Tree> list = FOREST;
        synchronized (list) {
            return FOREST.size();
        }
    }

    private Timber() {
        throw new AssertionError((Object)"No instances.");
    }

    public static class DebugTree
    extends Tree {
        private static final int MAX_LOG_LENGTH = 4000;
        private static final int MAX_TAG_LENGTH = 23;
        private static final int CALL_STACK_INDEX = 5;
        private static final Pattern ANONYMOUS_CLASS = Pattern.compile("(\\$\\d+)+$");

        @Nullable
        protected String createStackElementTag(@NotNull StackTraceElement element) {
            String tag = element.getClassName();
            Matcher m = ANONYMOUS_CLASS.matcher(tag);
            if (m.find()) {
                tag = m.replaceAll("");
            }
            if ((tag = tag.substring(tag.lastIndexOf(46) + 1)).length() <= 23 || Build.VERSION.SDK_INT >= 24) {
                return tag;
            }
            return tag.substring(0, 23);
        }

        @Override
        final String getTag() {
            String tag = super.getTag();
            if (tag != null) {
                return tag;
            }
            StackTraceElement[] stackTrace = new Throwable().getStackTrace();
            if (stackTrace.length <= 5) {
                throw new IllegalStateException("Synthetic stacktrace didn't have enough elements: are you using proguard?");
            }
            return this.createStackElementTag(stackTrace[5]);
        }

        @Override
        protected void log(int priority, String tag, @NotNull String message, Throwable t) {
            if (message.length() < 4000) {
                if (priority == 7) {
                    Log.wtf((String)tag, (String)message);
                } else {
                    Log.println((int)priority, (String)tag, (String)message);
                }
                return;
            }
            int length = message.length();
            for (int i = 0; i < length; ++i) {
                int end;
                int newline = message.indexOf(10, i);
                newline = newline != -1 ? newline : length;
                do {
                    end = Math.min(newline, i + 4000);
                    String part = message.substring(i, end);
                    if (priority == 7) {
                        Log.wtf((String)tag, (String)part);
                        continue;
                    }
                    Log.println((int)priority, (String)tag, (String)part);
                } while ((i = end) < newline);
            }
        }
    }

    public static abstract class Tree {
        final ThreadLocal<String> explicitTag = new ThreadLocal();

        @Nullable
        String getTag() {
            String tag = this.explicitTag.get();
            if (tag != null) {
                this.explicitTag.remove();
            }
            return tag;
        }

        public void v(String message, Object ... args) {
            this.prepareLog(2, null, message, args);
        }

        public void v(Throwable t, String message, Object ... args) {
            this.prepareLog(2, t, message, args);
        }

        public void v(Throwable t) {
            this.prepareLog(2, t, null, new Object[0]);
        }

        public void d(String message, Object ... args) {
            this.prepareLog(3, null, message, args);
        }

        public void d(Throwable t, String message, Object ... args) {
            this.prepareLog(3, t, message, args);
        }

        public void d(Throwable t) {
            this.prepareLog(3, t, null, new Object[0]);
        }

        public void i(String message, Object ... args) {
            this.prepareLog(4, null, message, args);
        }

        public void i(Throwable t, String message, Object ... args) {
            this.prepareLog(4, t, message, args);
        }

        public void i(Throwable t) {
            this.prepareLog(4, t, null, new Object[0]);
        }

        public void w(String message, Object ... args) {
            this.prepareLog(5, null, message, args);
        }

        public void w(Throwable t, String message, Object ... args) {
            this.prepareLog(5, t, message, args);
        }

        public void w(Throwable t) {
            this.prepareLog(5, t, null, new Object[0]);
        }

        public void e(String message, Object ... args) {
            this.prepareLog(6, null, message, args);
        }

        public void e(Throwable t, String message, Object ... args) {
            this.prepareLog(6, t, message, args);
        }

        public void e(Throwable t) {
            this.prepareLog(6, t, null, new Object[0]);
        }

        public void wtf(String message, Object ... args) {
            this.prepareLog(7, null, message, args);
        }

        public void wtf(Throwable t, String message, Object ... args) {
            this.prepareLog(7, t, message, args);
        }

        public void wtf(Throwable t) {
            this.prepareLog(7, t, null, new Object[0]);
        }

        public void log(int priority, String message, Object ... args) {
            this.prepareLog(priority, null, message, args);
        }

        public void log(int priority, Throwable t, String message, Object ... args) {
            this.prepareLog(priority, t, message, args);
        }

        public void log(int priority, Throwable t) {
            this.prepareLog(priority, t, null, new Object[0]);
        }

        @Deprecated
        protected boolean isLoggable(int priority) {
            return true;
        }

        protected boolean isLoggable(@Nullable String tag, int priority) {
            return this.isLoggable(priority);
        }

        private void prepareLog(int priority, Throwable t, String message, Object ... args) {
            String tag = this.getTag();
            if (!this.isLoggable(tag, priority)) {
                return;
            }
            if (message != null && message.length() == 0) {
                message = null;
            }
            if (message == null) {
                if (t == null) {
                    return;
                }
                message = this.getStackTraceString(t);
            } else {
                if (args != null && args.length > 0) {
                    message = this.formatMessage(message, args);
                }
                if (t != null) {
                    message = message + "\n" + this.getStackTraceString(t);
                }
            }
            this.log(priority, tag, message, t);
        }

        protected String formatMessage(@NotNull String message, @NotNull Object[] args) {
            return String.format(message, args);
        }

        private String getStackTraceString(Throwable t) {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter((Writer)sw, false);
            t.printStackTrace(pw);
            pw.flush();
            return sw.toString();
        }

        protected abstract void log(int var1, @Nullable String var2, @NotNull String var3, @Nullable Throwable var4);
    }
}

