/*
 * Decompiled with CFR 0.152.
 */
package com.appspress.component.properties.repository;

import com.appspress.component.properties.model.PropertyListModel;
import com.appspress.component.properties.repository.IPropertiesRepository;
import com.appspress.component.properties.repository.storage.IInternalStorage;
import com.appspress.component.properties.repository.storage.ILocalStorage;
import com.appspress.component.properties.repository.storage.IMemoryStorage;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0018\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00182\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0018\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00182\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0018\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00182\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0018\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0016J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/appspress/component/properties/repository/PropertiesRepository;", "Lcom/appspress/component/properties/repository/IPropertiesRepository;", "localStorage", "Lcom/appspress/component/properties/repository/storage/ILocalStorage;", "memoryStorage", "Lcom/appspress/component/properties/repository/storage/IMemoryStorage;", "internalStorage", "Lcom/appspress/component/properties/repository/storage/IInternalStorage;", "(Lcom/appspress/component/properties/repository/storage/ILocalStorage;Lcom/appspress/component/properties/repository/storage/IMemoryStorage;Lcom/appspress/component/properties/repository/storage/IInternalStorage;)V", "appendListToInternalAsync", "Lkotlinx/coroutines/Job;", "key", "", "value", "", "clearInternalListAsync", "Lcom/appspress/component/properties/model/PropertyListModel;", "recordsToKeep", "", "deleteFromInternal", "property", "deleteFromLocal", "deleteFromMemory", "getFromInternalAsync", "Lkotlinx/coroutines/Deferred;", "getFromLocalAsync", "getFromMemoryAsync", "getListFromInternalAsync", "putListToInternalAsync", "list", "putToInternal", "putToLocal", "putToMemory", "properties-android_release"})
public final class PropertiesRepository
implements IPropertiesRepository {
    private final ILocalStorage localStorage;
    private final IMemoryStorage memoryStorage;
    private final IInternalStorage internalStorage;

    @Nullable
    public Job putToLocal(@NotNull String property, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.localStorage.setPropertyAsync(property, value);
    }

    @NotNull
    public Deferred<String> getFromLocalAsync(@NotNull String property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        return this.localStorage.getPropertyAsync(property);
    }

    @Nullable
    public Job deleteFromLocal(@NotNull String property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        return this.localStorage.deletePropertyAsync(property);
    }

    @Nullable
    public Job putToMemory(@NotNull String property, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.memoryStorage.setPropertyAsync(property, value);
    }

    @NotNull
    public Deferred<String> getFromMemoryAsync(@NotNull String property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        return this.memoryStorage.getPropertyAsync(property);
    }

    @Nullable
    public Job deleteFromMemory(@NotNull String property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        return this.memoryStorage.deletePropertyAsync(property);
    }

    @Nullable
    public Job putToInternal(@NotNull String property, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.internalStorage.setPropertyAsync(property, value);
    }

    @NotNull
    public Deferred<String> getFromInternalAsync(@NotNull String property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        return this.internalStorage.getPropertyAsync(property);
    }

    @Nullable
    public Job deleteFromInternal(@NotNull String property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        return this.internalStorage.deletePropertyAsync(property);
    }

    @NotNull
    public Deferred<PropertyListModel> getListFromInternalAsync(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.internalStorage.getListAsync(key);
    }

    @Nullable
    public Job putListToInternalAsync(@NotNull String key, @NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        return this.internalStorage.putListAsync(key, list);
    }

    @Nullable
    public Job appendListToInternalAsync(@NotNull String key, @NotNull List<String> value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        return this.internalStorage.appendListAsync(key, value);
    }

    @Nullable
    public Job clearInternalListAsync(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.internalStorage.clearListAsync(key);
    }

    @Nullable
    public Job clearInternalListAsync(@NotNull String key, @NotNull PropertyListModel value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.internalStorage.clearListAsync(key, value);
    }

    @Nullable
    public Job clearInternalListAsync(@NotNull String key, int recordsToKeep) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.internalStorage.clearListAsync(key, recordsToKeep);
    }

    @Inject
    public PropertiesRepository(@NotNull ILocalStorage localStorage, @NotNull IMemoryStorage memoryStorage, @NotNull IInternalStorage internalStorage) {
        Intrinsics.checkParameterIsNotNull((Object)localStorage, (String)"localStorage");
        Intrinsics.checkParameterIsNotNull((Object)memoryStorage, (String)"memoryStorage");
        Intrinsics.checkParameterIsNotNull((Object)internalStorage, (String)"internalStorage");
        this.localStorage = localStorage;
        this.memoryStorage = memoryStorage;
        this.internalStorage = internalStorage;
    }
}

