/*
 * Decompiled with CFR 0.152.
 */
package com.appspress.component.location;

import android.annotation.SuppressLint;
import android.content.Context;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.HandlerThread;
import com.appspress.component.location.FailedToRegisterCallback;
import com.appspress.component.location.ISingleSourceLocationManager;
import com.appspress.component.location.LocationUpdateAdapterProvider;
import com.appspress.component.location.LocationUpdateCallback;
import com.appspress.component.location.MissingPermission;
import com.appspress.component.location.SingleSourceLocationManagerLogger;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0003J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/appspress/component/location/SingleSourceLocationManager;", "Lcom/appspress/component/location/ISingleSourceLocationManager;", "context", "Landroid/content/Context;", "logger", "Lcom/appspress/component/location/SingleSourceLocationManagerLogger;", "locationUpdateAdapterProvider", "Lcom/appspress/component/location/LocationUpdateAdapterProvider;", "(Landroid/content/Context;Lcom/appspress/component/location/SingleSourceLocationManagerLogger;Lcom/appspress/component/location/LocationUpdateAdapterProvider;)V", "handlerThread", "Landroid/os/HandlerThread;", "registerForLocationUpdates", "", "callback", "Lcom/appspress/component/location/LocationUpdateCallback;", "subscribe", "location-component_release"})
public final class SingleSourceLocationManager
implements ISingleSourceLocationManager {
    private final HandlerThread handlerThread;
    private final Context context;
    private final SingleSourceLocationManagerLogger logger;
    private final LocationUpdateAdapterProvider locationUpdateAdapterProvider;

    @Override
    public void subscribe(@NotNull LocationUpdateCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        this.registerForLocationUpdates(callback);
    }

    @SuppressLint(value={"MissingPermission"})
    private final void registerForLocationUpdates(LocationUpdateCallback callback) {
        block8: {
            if (this.context.checkCallingOrSelfPermission("android.permission.ACCESS_FINE_LOCATION") != 0) {
                LocationUpdateCallback locationUpdateCallback = callback;
                boolean bl = false;
                try {
                    Object object = Result.Companion;
                    LocationUpdateCallback $this$runCatching = locationUpdateCallback;
                    boolean bl2 = false;
                    $this$runCatching.onError(MissingPermission.INSTANCE);
                    Unit unit = Unit.INSTANCE;
                    bl2 = false;
                    object = Result.constructor-impl((Object)unit);
                }
                catch (Throwable throwable) {
                    Result.Companion bl2 = Result.Companion;
                    boolean bl3 = false;
                    Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                return;
            }
            try {
                LocationManager service;
                Object object = this.context.getSystemService("location");
                if (!(object instanceof LocationManager)) {
                    object = null;
                }
                LocationManager locationManager = service = (LocationManager)object;
                if (locationManager == null) break block8;
                locationManager.requestSingleUpdate("gps", (LocationListener)this.locationUpdateAdapterProvider.provide(callback), this.handlerThread.getLooper());
            }
            catch (Exception e) {
                Object object;
                this.logger.failedToRegisterForLocationUpdates(e);
                LocationUpdateCallback locationUpdateCallback = callback;
                boolean bl = false;
                try {
                    object = Result.Companion;
                    LocationUpdateCallback $this$runCatching = locationUpdateCallback;
                    boolean bl4 = false;
                    $this$runCatching.onError(new FailedToRegisterCallback(e));
                    Unit unit = Unit.INSTANCE;
                    boolean bl5 = false;
                    object = Result.constructor-impl((Object)unit);
                }
                catch (Throwable throwable) {
                    Result.Companion companion = Result.Companion;
                    boolean bl6 = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                locationUpdateCallback = object;
                bl = false;
                boolean bl7 = false;
                Throwable throwable = Result.exceptionOrNull-impl((Object)locationUpdateCallback);
                if (throwable == null) break block8;
                Throwable throwable2 = throwable;
                boolean bl8 = false;
                boolean bl9 = false;
                Throwable throwable3 = throwable2;
                boolean bl10 = false;
                Throwable it = throwable3;
                boolean bl11 = false;
            }
        }
    }

    public SingleSourceLocationManager(@NotNull Context context, @NotNull SingleSourceLocationManagerLogger logger, @NotNull LocationUpdateAdapterProvider locationUpdateAdapterProvider) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)locationUpdateAdapterProvider, (String)"locationUpdateAdapterProvider");
        this.context = context;
        this.logger = logger;
        this.locationUpdateAdapterProvider = locationUpdateAdapterProvider;
        this.handlerThread = new HandlerThread("LocationUpdatesHandlerThread");
    }
}

