/*
 * Decompiled with CFR 0.152.
 */
package com.appspress.component.imei;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import androidx.annotation.RequiresApi;
import com.appspress.component.imei.IImeiLogger;
import com.appspress.component.imei.IImeiManager;
import com.appspress.component.imei.IImeiRepository;
import com.appspress.component.imei.ImeiManager;
import com.appspress.component.imei.ImeiManager$getImeiAtSlot$;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0017J\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000b0\u000eH\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u000b*\u00020\u0013H\u0003J\"\u0010\u0016\u001a\u0004\u0018\u00010\u000b*\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000f2\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aH\u0002J\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u000b*\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u000fH\u0003J\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u000b*\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u000fH\u0003J\u001b\u0010\u001e\u001a\u00020\u000b\"\b\b\u0000\u0010\u001f*\u00020 *\u0002H\u001fH\u0002\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/appspress/component/imei/ImeiManager;", "Lcom/appspress/component/imei/IImeiManager;", "appContext", "Landroid/content/Context;", "logger", "Lcom/appspress/component/imei/IImeiLogger;", "repository", "Lcom/appspress/component/imei/IImeiRepository;", "(Landroid/content/Context;Lcom/appspress/component/imei/IImeiLogger;Lcom/appspress/component/imei/IImeiRepository;)V", "getDeviceImeis", "", "", "getDevicePhoneNumbers", "getImeisFromSystem", "", "", "getLastImeiError", "getPhoneCount", "manager", "Landroid/telephony/TelephonyManager;", "getTelephonyManager", "getImeiApi1", "getImeiAtSlot", "slot", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getImeiAtSlotIndexAPI23", "slotIndex", "getImeiAtSlotIndexAPI26", "textStackTrace", "Error", "", "(Ljava/lang/Throwable;)Ljava/lang/String;", "Companion", "imei-component_release"})
public final class ImeiManager
implements IImeiManager {
    private final Context appContext;
    private final IImeiLogger logger;
    private final IImeiRepository repository;
    private static final int MIN_PHONE_COUNT = 2;
    private static final int MAX_PHONE_COUNT = 10;
    private static final int WHAT_MAXIMUM_ELEMENTS_OF_IMEI_DATA_SHOULD_BE_STORED_IN_REPOSITORY = 6;
    private static final long OVERALL_TIMEOUT_MILLIS = 120000L;
    private static final long SINGLE_IMEI_RETREIVE_TIMEOUT_MILLIS = 12000L;
    private static final int LEGACY_ANDROID_PHONE_COUNT = 1;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public List<String> getDeviceImeis() {
        List list;
        Map<Integer, String> imeis = this.getImeisFromSystem();
        if (imeis.values().size() != 2) {
            Map map = this.repository.getImeis();
            if (map == null) {
                boolean bl = false;
                map = MapsKt.emptyMap();
            }
            Map imeisFromCache = map;
            this.logger.logReturnedImeiCountFromSystemDifferExpected(imeis, imeisFromCache, 2);
            Map result2 = MapsKt.toMap((Sequence)SequencesKt.map((Sequence)SequencesKt.take((Sequence)MapsKt.asSequence((Map)MapsKt.plus((Map)new LinkedHashMap(imeisFromCache), (Map)new LinkedHashMap<Integer, String>(imeis))), (int)6), (Function1)getDeviceImeis.result.1.INSTANCE));
            this.logger.logInfoGetDeviceImeisResult(result2);
            this.repository.storeImeis(result2);
            list = CollectionsKt.toList((Iterable)result2.values());
        } else {
            this.repository.storeImeis(imeis);
            list = CollectionsKt.toList((Iterable)imeis.values());
        }
        return list;
    }

    @Override
    @Nullable
    public String getLastImeiError() {
        return this.repository.getLastImeiException();
    }

    @Override
    @SuppressLint(value={"MissingPermission", "HardwareIds"})
    @NotNull
    public List<String> getDevicePhoneNumbers() {
        String string;
        TelephonyManager telephonyManager = this.getTelephonyManager();
        if (telephonyManager == null) {
            return CollectionsKt.emptyList();
        }
        TelephonyManager telephonyManager2 = telephonyManager;
        try {
            string = telephonyManager2.getLine1Number();
        }
        catch (Exception e) {
            string = null;
        }
        boolean bl = false;
        boolean bl2 = false;
        String number = string;
        boolean bl3 = false;
        CharSequence charSequence = number;
        boolean bl4 = false;
        boolean bl5 = false;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)number);
    }

    private final Map<Integer, String> getImeisFromSystem() {
        TelephonyManager telephonyManager = this.getTelephonyManager();
        if (telephonyManager == null) {
            return MapsKt.emptyMap();
        }
        TelephonyManager telephonyManager2 = telephonyManager;
        boolean bl = false;
        Map imeis = new LinkedHashMap();
        int phoneCount = this.getPhoneCount(telephonyManager2);
        StringBuilder errorsText = new StringBuilder();
        if (phoneCount != 2) {
            this.logger.phoneCountDifferFromExpected(phoneCount, 2);
            int imeiCountToFetch = RangesKt.coerceIn((int)phoneCount, (int)2, (int)10);
            boolean bl2 = false;
            int n = 0;
            int n2 = imeiCountToFetch;
            for (n = 0; n < n2; ++n) {
                String string;
                int i = n;
                boolean bl3 = false;
                if (this.getImeiAtSlot(telephonyManager2, i, errorsText) == null) continue;
                boolean bl4 = false;
                boolean bl5 = false;
                String imei = string;
                boolean bl6 = false;
                imeis.put(i, imei);
            }
        } else {
            int n = 2;
            boolean bl7 = false;
            int n3 = 0;
            int n4 = n;
            for (n3 = 0; n3 < n4; ++n3) {
                String string;
                int i = n3;
                boolean bl8 = false;
                if (this.getImeiAtSlot(telephonyManager2, i, errorsText) == null) continue;
                boolean bl9 = false;
                boolean bl10 = false;
                String imei = string;
                boolean bl11 = false;
                imeis.put(i, imei);
            }
        }
        String string = errorsText.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"errorsText.toString()");
        this.repository.storeLastImeiException(string);
        return imeis;
    }

    private final TelephonyManager getTelephonyManager() {
        TelephonyManager telephonyManager;
        try {
            Object object = this.appContext.getSystemService("phone");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
            }
            telephonyManager = (TelephonyManager)object;
        }
        catch (Exception e) {
            this.repository.storeLastImeiException(this.textStackTrace((Throwable)e));
            this.logger.logFailedToGetSystemService(e);
            telephonyManager = null;
        }
        return telephonyManager;
    }

    private final int getPhoneCount(TelephonyManager manager) {
        return Build.VERSION.SDK_INT >= 23 ? manager.getPhoneCount() : 1;
    }

    private final String getImeiAtSlot(@NotNull TelephonyManager $this$getImeiAtSlot, int slot, StringBuilder sb) {
        Object object;
        TelephonyManager telephonyManager = $this$getImeiAtSlot;
        boolean bl = false;
        try {
            object = Result.Companion;
            TelephonyManager $this$runCatching = telephonyManager;
            boolean bl2 = false;
            String string = (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>($this$runCatching, null, this, slot, sb){
                private CoroutineScope p$;
                int label;
                final /* synthetic */ TelephonyManager $this_runCatching;
                final /* synthetic */ ImeiManager this$0;
                final /* synthetic */ int $slot$inlined;
                final /* synthetic */ StringBuilder $sb$inlined;
                {
                    this.$this_runCatching = telephonyManager;
                    this.this$0 = imeiManager;
                    this.$slot$inlined = n;
                    this.$sb$inlined = stringBuilder;
                    super(2, continuation);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object result2) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)result2);
                            CoroutineScope coroutineScope = this.p$;
                            this.label = 1;
                            Object object2 = TimeoutKt.withTimeoutOrNull((long)12000L, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(this, null){
                                private CoroutineScope p$;
                                int label;
                                final /* synthetic */ getImeiAtSlot$$inlined$runCatching$lambda$1 this$0;
                                {
                                    this.this$0 = var1_1;
                                    super(2, continuation);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object result2) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            String string;
                                            ResultKt.throwOnFailure((Object)result2);
                                            CoroutineScope coroutineScope = this.p$;
                                            if (Build.VERSION.SDK_INT >= 26) {
                                                String string2;
                                                try {
                                                    string2 = ImeiManager.access$getImeiAtSlotIndexAPI26(this.this$0.this$0, this.this$0.$this_runCatching, this.this$0.$slot$inlined);
                                                }
                                                catch (Exception e) {
                                                    this.this$0.$sb$inlined.append(ImeiManager.access$textStackTrace(this.this$0.this$0, e) + "\n");
                                                    ImeiManager.access$getLogger$p(this.this$0.this$0).exceptionOccurredWhenFetchedImeiAtSlotWithAPI26Method(e, this.this$0.$slot$inlined);
                                                    try {
                                                        ImeiManager.access$getImeiAtSlotIndexAPI23(this.this$0.this$0, this.this$0.$this_runCatching, this.this$0.$slot$inlined);
                                                    }
                                                    catch (Exception e2) {
                                                        this.this$0.$sb$inlined.append(ImeiManager.access$textStackTrace(this.this$0.this$0, e2) + "\n");
                                                        ImeiManager.access$getLogger$p(this.this$0.this$0).exceptionOccurredWhenTryingToGetImeiWithAPI23MethodAfterAPI26MethodFails(e2, this.this$0.$slot$inlined);
                                                    }
                                                    string2 = null;
                                                }
                                                string = string2;
                                            } else if (Build.VERSION.SDK_INT >= 23) {
                                                String string3;
                                                try {
                                                    String string4;
                                                    String string5 = ImeiManager.access$getImeiAtSlotIndexAPI23(this.this$0.this$0, this.this$0.$this_runCatching, this.this$0.$slot$inlined);
                                                    if (string5 != null) {
                                                        string3 = string5;
                                                        boolean e = false;
                                                        boolean bl = false;
                                                        String imei = string3;
                                                        boolean bl2 = false;
                                                        string4 = imei;
                                                    } else {
                                                        string4 = null;
                                                    }
                                                    string3 = string4;
                                                }
                                                catch (Exception e) {
                                                    this.this$0.$sb$inlined.append(ImeiManager.access$textStackTrace(this.this$0.this$0, e) + "\n");
                                                    ImeiManager.access$getLogger$p(this.this$0.this$0).exceptionOccurredWhenFetchedImeiAtSlotWithAPI23Method(e, this.this$0.$slot$inlined);
                                                    string3 = null;
                                                }
                                                string = string3;
                                            } else {
                                                Object var4_6;
                                                try {
                                                    ImeiManager.access$getImeiApi1(this.this$0.this$0, this.this$0.$this_runCatching);
                                                    var4_6 = null;
                                                }
                                                catch (Exception e) {
                                                    this.this$0.$sb$inlined.append(ImeiManager.access$textStackTrace(this.this$0.this$0, e) + "\n");
                                                    ImeiManager.access$getLogger$p(this.this$0.this$0).exceptionOccurredWhenFetchedImeiAtSlotWithAPI1Method(e, this.this$0.$slot$inlined);
                                                    var4_6 = null;
                                                }
                                                string = var4_6;
                                            }
                                            return string;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                    Function2<CoroutineScope, Continuation<? super String>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                    CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                                    function2.p$ = (CoroutineScope)value;
                                    Function2<CoroutineScope, Continuation<? super String>, Object> function22 = function2;
                                    return function22;
                                }

                                public final Object invoke(Object object, Object object2) {
                                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)this);
                            Object object3 = object2;
                            if (object2 != object) return object3;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)result2);
                            Object object3 = result2;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super String>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                    function2.p$ = (CoroutineScope)value;
                    Function2<CoroutineScope, Continuation<? super String>, Object> function22 = function2;
                    return function22;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            boolean bl3 = false;
            object = Result.constructor-impl((Object)string);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        telephonyManager = object;
        bl = false;
        boolean bl5 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)telephonyManager);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl6 = false;
            boolean bl7 = false;
            Throwable throwable3 = throwable2;
            boolean bl8 = false;
            Throwable it = throwable3;
            boolean bl9 = false;
            sb.append(this.textStackTrace(it) + "\n");
        }
        bl = false;
        return (String)(Result.isFailure-impl((Object)telephonyManager) ? null : telephonyManager);
    }

    @SuppressLint(value={"MissingPermission"})
    @RequiresApi(value=26)
    private final String getImeiAtSlotIndexAPI26(@NotNull TelephonyManager $this$getImeiAtSlotIndexAPI26, int slotIndex) {
        return $this$getImeiAtSlotIndexAPI26.getImei(slotIndex);
    }

    @SuppressLint(value={"HardwareIds", "MissingPermission"})
    @RequiresApi(value=23)
    private final String getImeiAtSlotIndexAPI23(@NotNull TelephonyManager $this$getImeiAtSlotIndexAPI23, int slotIndex) {
        return $this$getImeiAtSlotIndexAPI23.getDeviceId(slotIndex);
    }

    @SuppressLint(value={"HardwareIds", "MissingPermission"})
    @TargetApi(value=22)
    private final String getImeiApi1(@NotNull TelephonyManager $this$getImeiApi1) {
        PackageManager packageManager = this.appContext.getPackageManager();
        int permissionCheckResult = packageManager.checkPermission("android.permission.READ_PHONE_STATE", this.appContext.getPackageName());
        return permissionCheckResult == 0 ? $this$getImeiApi1.getDeviceId() : null;
    }

    private final <Error extends Throwable> String textStackTrace(@NotNull Error $this$textStackTrace) {
        Object object;
        try {
            object = new StringWriter();
            StringBuilder stringBuilder = new StringBuilder().append("\nStacktrace:\n\n");
            boolean bl = false;
            boolean bl2 = false;
            Object $this$apply = object;
            boolean bl3 = false;
            $this$textStackTrace.printStackTrace(new PrintWriter((Writer)$this$apply));
            Object object2 = object;
            object = stringBuilder.append(object2).toString();
        }
        catch (Exception ignored) {
            object = "\nFailed to read stacktrace: " + ignored + "\nOriginal Error: " + $this$textStackTrace;
        }
        return object;
    }

    public ImeiManager(@NotNull Context appContext, @NotNull IImeiLogger logger, @NotNull IImeiRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)appContext, (String)"appContext");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        this.appContext = appContext;
        this.logger = logger;
        this.repository = repository;
    }

    public static final /* synthetic */ String access$getImeiAtSlotIndexAPI26(ImeiManager $this, TelephonyManager $this$access_u24getImeiAtSlotIndexAPI26, int slotIndex) {
        return $this.getImeiAtSlotIndexAPI26($this$access_u24getImeiAtSlotIndexAPI26, slotIndex);
    }

    public static final /* synthetic */ String access$textStackTrace(ImeiManager $this, Throwable $this$access_u24textStackTrace) {
        return $this.textStackTrace($this$access_u24textStackTrace);
    }

    public static final /* synthetic */ IImeiLogger access$getLogger$p(ImeiManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$getImeiAtSlotIndexAPI23(ImeiManager $this, TelephonyManager $this$access_u24getImeiAtSlotIndexAPI23, int slotIndex) {
        return $this.getImeiAtSlotIndexAPI23($this$access_u24getImeiAtSlotIndexAPI23, slotIndex);
    }

    public static final /* synthetic */ String access$getImeiApi1(ImeiManager $this, TelephonyManager $this$access_u24getImeiApi1) {
        return $this.getImeiApi1($this$access_u24getImeiApi1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/appspress/component/imei/ImeiManager$Companion;", "", "()V", "LEGACY_ANDROID_PHONE_COUNT", "", "MAX_PHONE_COUNT", "MIN_PHONE_COUNT", "OVERALL_TIMEOUT_MILLIS", "", "SINGLE_IMEI_RETREIVE_TIMEOUT_MILLIS", "WHAT_MAXIMUM_ELEMENTS_OF_IMEI_DATA_SHOULD_BE_STORED_IN_REPOSITORY", "imei-component_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

