/*
 * Decompiled with CFR 0.152.
 */
package com.appspress.component.imei;

import android.annotation.SuppressLint;
import com.appspress.component.imei.IImeiLogger;
import com.appspress.component.imei.di.ImeiComponentComponentScope;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@ImeiComponentComponentScope
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u001c\u0010\n\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\u000b\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\f\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0014\u0010\r\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0016J\u001c\u0010\u000e\u001a\u00020\u00042\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J8\u0010\u0013\u001a\u00020\u00042\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\u00102\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0016\u001a\u00020\tH\u0017J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\u0016\u00a8\u0006\u0019"}, d2={"Lcom/appspress/component/imei/ImeiLogger;", "Lcom/appspress/component/imei/IImeiLogger;", "()V", "exceptionOccurredWhenFetchedImeiAtSlotWithAPI1Method", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "slot", "", "exceptionOccurredWhenFetchedImeiAtSlotWithAPI23Method", "exceptionOccurredWhenFetchedImeiAtSlotWithAPI26Method", "exceptionOccurredWhenTryingToGetImeiWithAPI23MethodAfterAPI26MethodFails", "logFailedToGetSystemService", "logInfoGetDeviceImeisResult", "result", "", "", "logMissingReadPhoneStatePermission", "logReturnedImeiCountFromSystemDifferExpected", "imeisFromSystem", "imeisFromChache", "expectedCount", "phoneCountDifferFromExpected", "phoneCount", "imei-component_release"})
public final class ImeiLogger
implements IImeiLogger {
    @Override
    public void logMissingReadPhoneStatePermission() {
        Timber.e(new IllegalStateException("Permission READ_PHONE_STATE is not granted, system will not return any IMEIs."));
    }

    @Override
    public void phoneCountDifferFromExpected(int phoneCount, int expectedCount) {
        Timber.e("Telephony manager returned " + phoneCount + " phone count but " + expectedCount + " expected.", new Object[0]);
    }

    @Override
    @SuppressLint(value={"BinaryOperationInTimber"})
    public void logReturnedImeiCountFromSystemDifferExpected(@NotNull Map<Integer, String> imeisFromSystem, @NotNull Map<Integer, String> imeisFromChache, int expectedCount) {
        Intrinsics.checkParameterIsNotNull(imeisFromSystem, (String)"imeisFromSystem");
        Intrinsics.checkParameterIsNotNull(imeisFromChache, (String)"imeisFromChache");
        Timber.e("System returned " + imeisFromSystem.size() + " IMEIs, expected " + expectedCount + ", " + "cache contains " + imeisFromChache.size(), new Object[0]);
    }

    @Override
    public void logInfoGetDeviceImeisResult(@NotNull Map<Integer, String> result2) {
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        Timber.e("Imei manager return resulting imeis " + result2 + " to caller.", new Object[0]);
    }

    @Override
    public void logFailedToGetSystemService(@NotNull Exception e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Timber.e(e, "Failed to get TELEPHONY_SERVICE system service.", new Object[0]);
    }

    @Override
    public void exceptionOccurredWhenFetchedImeiAtSlotWithAPI26Method(@NotNull Exception e, int slot) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Timber.e(e, "Exception occurred when fetched imei as slot " + slot + " with API26 method.", new Object[0]);
    }

    @Override
    public void exceptionOccurredWhenFetchedImeiAtSlotWithAPI23Method(@NotNull Exception e, int slot) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Timber.e(e, "Exception occurred when fetched imei as slot " + slot + " with API23 method.", new Object[0]);
    }

    @Override
    @SuppressLint(value={"BinaryOperationInTimber"})
    public void exceptionOccurredWhenFetchedImeiAtSlotWithAPI1Method(@NotNull Exception e, int slot) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Timber.e(e, "Exception occurred when fetched imei as slot " + slot + " with API1 method.", new Object[0]);
    }

    @Override
    @SuppressLint(value={"BinaryOperationInTimber"})
    public void exceptionOccurredWhenTryingToGetImeiWithAPI23MethodAfterAPI26MethodFails(@NotNull Exception e, int slot) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Timber.e(e, "Exception occurred when fetched imei as slot " + slot + " with API23 method " + "after API26 method failed.", new Object[0]);
    }

    @Inject
    public ImeiLogger() {
    }
}

