/*
 * Decompiled with CFR 0.152.
 */
package com.appspress.component.accountmanager;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.annotation.SuppressLint;
import android.app.Application;
import com.appspress.component.accountmanager.AccountManagerComponentScope;
import com.appspress.component.accountmanager.FailedToGetAccountManagerException;
import com.appspress.component.accountmanager.FailedToGetAccountsException;
import com.appspress.component.accountmanager.IAccountManagerResultCallback;
import com.appspress.component.accountmanager.ISingleSourceAccountManager;
import com.appspress.component.accountmanager.MissingGetAccountsPermissionException;
import com.appspress.component.accountmanager.SingleSourceAccountManagerException;
import com.appspress.component.accountmanager.SingleSourceAccountManagerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AccountManagerComponentScope
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0017J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/appspress/component/accountmanager/SingleSourceAccountManager;", "Lcom/appspress/component/accountmanager/ISingleSourceAccountManager;", "app", "Landroid/app/Application;", "(Landroid/app/Application;)V", "getGoogleAccounts", "", "", "getGoogleAccountsAsync", "", "callback", "Lcom/appspress/component/accountmanager/IAccountManagerResultCallback;", "isAccountsPermissionGranted", "", "Companion", "account-manager-component_release"})
public final class SingleSourceAccountManager
implements ISingleSourceAccountManager {
    private final Application app;
    private static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    @SuppressLint(value={"MissingPermission"})
    @NotNull
    public List<String> getGoogleAccounts() throws SingleSourceAccountManagerException {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        List e2;
        AccountManager accountManager;
        try {
            Object object = this.app.getSystemService("account");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.accounts.AccountManager");
            }
            accountManager = (AccountManager)object;
        }
        catch (Exception e2) {
            throw (Throwable)new FailedToGetAccountManagerException(e2);
        }
        AccountManager systemAccountManager = accountManager;
        if (!this.isAccountsPermissionGranted()) {
            throw (Throwable)new MissingGetAccountsPermissionException();
        }
        try {
            Object[] objectArray = systemAccountManager.getAccounts();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"systemAccountManager.accounts");
            e2 = ArraysKt.toList((Object[])objectArray);
        }
        catch (Exception e3) {
            throw (Throwable)new FailedToGetAccountsException(e3);
        }
        List accounts = e2;
        Iterable $this$filter$iv = accounts;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Account it = (Account)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.type, (Object)GOOGLE_ACCOUNT_TYPE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Account it = (Account)element$iv$iv;
            boolean bl2 = false;
            if (it.name == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void getGoogleAccountsAsync(@NotNull IAccountManagerResultCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        SingleSourceAccountManagerKt.access$doAsync((Function0)new Function0<List<? extends String>>(this, callback){
            final /* synthetic */ SingleSourceAccountManager this$0;
            final /* synthetic */ IAccountManagerResultCallback $callback;

            @Nullable
            public final List<String> invoke() {
                List<String> list;
                try {
                    list = this.this$0.getGoogleAccounts();
                }
                catch (SingleSourceAccountManagerException e) {
                    this.$callback.onError(e);
                    list = null;
                }
                return list;
            }
            {
                this.this$0 = singleSourceAccountManager;
                this.$callback = iAccountManagerResultCallback;
                super(0);
            }
        }, (Function1)new Function1<List<? extends String>, Unit>(callback){
            final /* synthetic */ IAccountManagerResultCallback $callback;

            public final void invoke(@Nullable List<String> accounts) {
                block0: {
                    List<String> list = accounts;
                    if (list == null) break block0;
                    List<String> list2 = list;
                    IAccountManagerResultCallback iAccountManagerResultCallback = this.$callback;
                    boolean bl = false;
                    boolean bl2 = false;
                    List<String> p1 = list2;
                    boolean bl3 = false;
                    iAccountManagerResultCallback.onSuccess(p1);
                }
            }
            {
                this.$callback = iAccountManagerResultCallback;
                super(1);
            }
        });
    }

    private final boolean isAccountsPermissionGranted() {
        return this.app.checkCallingOrSelfPermission("android.permission.GET_ACCOUNTS") == 0;
    }

    @Inject
    public SingleSourceAccountManager(@NotNull Application app) {
        Intrinsics.checkParameterIsNotNull((Object)app, (String)"app");
        this.app = app;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/appspress/component/accountmanager/SingleSourceAccountManager$Companion;", "", "()V", "GOOGLE_ACCOUNT_TYPE", "", "account-manager-component_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

