/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.ac;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import javax.security.auth.x500.X500Principal;

public class AFKeystoreWrapper {
    public final Object AFInAppEventParameterName = new Object();
    public KeyStore AFKeystoreWrapper;
    private Context AFInAppEventType;
    public String valueOf;
    public int values;

    public AFKeystoreWrapper(Context object) {
        this.AFInAppEventType = object;
        this.valueOf = "";
        this.values = 0;
        object = this;
        AFLogger.valueOf("Initialising KeyStore..");
        try {
            object.AFKeystoreWrapper = KeyStore.getInstance("AndroidKeyStore");
            object.AFKeystoreWrapper.load(null);
            return;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            AFLogger.valueOf("Couldn't load keystore instance of type: AndroidKeyStore", exception);
            return;
        }
    }

    public final boolean values() {
        boolean bl2 = false;
        Object object = this.AFInAppEventParameterName;
        synchronized (object) {
            if (this.AFKeystoreWrapper != null) {
                try {
                    String[] stringArray = this.AFKeystoreWrapper.aliases();
                    while (stringArray.hasMoreElements()) {
                        String[] stringArray2 = stringArray.nextElement();
                        if (stringArray2 == null || !com.appsflyer.AFKeystoreWrapper.AFInAppEventParameterName((String)stringArray2)) continue;
                        stringArray = stringArray2.split(",");
                        if (stringArray.length == 3) {
                            AFLogger.valueOf("Found a matching AF key with alias:\n".concat(String.valueOf(stringArray2)));
                            bl2 = true;
                            stringArray2 = stringArray[1].trim().split("=");
                            stringArray = stringArray[2].trim().split("=");
                            if (stringArray2.length == 2 && stringArray.length == 2) {
                                this.valueOf = stringArray2[1].trim();
                                this.values = Integer.parseInt(stringArray[1].trim());
                            }
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    AFLogger.valueOf("Couldn't list KeyStore Aliases: " + throwable.getClass().getName(), throwable);
                }
            }
        }
        return bl2;
    }

    public final void AFKeystoreWrapper(String object) {
        AFLogger.valueOf("Creating a new key with alias: ".concat(String.valueOf(object)));
        try {
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.add(1, 5);
            KeyGenParameterSpec keyGenParameterSpec = null;
            Object object2 = this.AFInAppEventParameterName;
            synchronized (object2) {
                if (!this.AFKeystoreWrapper.containsAlias((String)object)) {
                    if (Build.VERSION.SDK_INT >= 23) {
                        keyGenParameterSpec = new KeyGenParameterSpec.Builder((String)object, 3).setCertificateSubject(new X500Principal("CN=AndroidSDK, O=AppsFlyer")).setCertificateSerialNumber(BigInteger.ONE).setCertificateNotBefore(calendar.getTime()).setCertificateNotAfter(calendar2.getTime()).build();
                    } else if (Build.VERSION.SDK_INT >= 18 && !ac.AFInAppEventParameterName()) {
                        keyGenParameterSpec = new KeyPairGeneratorSpec.Builder(this.AFInAppEventType).setAlias((String)object).setSubject(new X500Principal("CN=AndroidSDK, O=AppsFlyer")).setSerialNumber(BigInteger.ONE).setStartDate(calendar.getTime()).setEndDate(calendar2.getTime()).build();
                    }
                    object = KeyPairGenerator.getInstance("RSA", "AndroidKeyStore");
                    ((KeyPairGenerator)object).initialize((AlgorithmParameterSpec)keyGenParameterSpec);
                    ((KeyPairGeneratorSpi)object).generateKeyPair();
                } else {
                    AFLogger.valueOf("Alias already exists: ".concat(String.valueOf(object)));
                }
                return;
            }
        }
        catch (Throwable throwable) {
            AFLogger.valueOf("Exception " + throwable.getMessage() + " occurred", throwable);
            return;
        }
    }

    private static boolean AFInAppEventParameterName(String string) {
        return string.startsWith("com.appsflyer");
    }

    public final String AFInAppEventType() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("com.appsflyer,");
        Object object = this.AFInAppEventParameterName;
        synchronized (object) {
            stringBuilder.append("KSAppsFlyerId=").append(this.valueOf).append(",");
            stringBuilder.append("KSAppsFlyerRICounter=").append(this.values);
        }
        return ((Object)stringBuilder).toString();
    }

    public final String AFInAppEventParameterName() {
        Object object = this.AFInAppEventParameterName;
        synchronized (object) {
            return this.valueOf;
        }
    }

    public final int valueOf() {
        Object object = this.AFInAppEventParameterName;
        synchronized (object) {
            return this.values;
        }
    }
}

