/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.aa;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import javax.security.auth.x500.X500Principal;

public class AFKeystoreWrapper {
    public final Object AFInAppEventType = new Object();
    public KeyStore values;
    private Context AFKeystoreWrapper;
    public String AFInAppEventParameterName;
    public int valueOf;

    public AFKeystoreWrapper(Context object) {
        this.AFKeystoreWrapper = object;
        this.AFInAppEventParameterName = "";
        this.valueOf = 0;
        object = this;
        AFLogger.AFKeystoreWrapper("Initialising KeyStore..");
        try {
            object.values = KeyStore.getInstance("AndroidKeyStore");
            object.values.load(null);
            return;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            AFLogger.AFInAppEventParameterName("Couldn't load keystore instance of type: AndroidKeyStore", exception);
            return;
        }
    }

    public final boolean AFInAppEventType() {
        boolean bl2 = false;
        Object object = this.AFInAppEventType;
        synchronized (object) {
            if (this.values != null) {
                try {
                    String[] stringArray = this.values.aliases();
                    while (stringArray.hasMoreElements()) {
                        String[] stringArray2 = stringArray.nextElement();
                        if (stringArray2 == null || !com.appsflyer.AFKeystoreWrapper.AFInAppEventType((String)stringArray2)) continue;
                        stringArray = stringArray2.split(",");
                        if (stringArray.length == 3) {
                            AFLogger.AFKeystoreWrapper("Found a matching AF key with alias:\n".concat(String.valueOf(stringArray2)));
                            bl2 = true;
                            stringArray2 = stringArray[1].trim().split("=");
                            stringArray = stringArray[2].trim().split("=");
                            if (stringArray2.length == 2 && stringArray.length == 2) {
                                this.AFInAppEventParameterName = stringArray2[1].trim();
                                this.valueOf = Integer.parseInt(stringArray[1].trim());
                            }
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    AFLogger.AFInAppEventParameterName("Couldn't list KeyStore Aliases: " + throwable.getClass().getName(), throwable);
                }
            }
        }
        return bl2;
    }

    public final void AFInAppEventParameterName(String object) {
        AFLogger.AFKeystoreWrapper("Creating a new key with alias: ".concat(String.valueOf(object)));
        try {
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.add(1, 5);
            KeyGenParameterSpec keyGenParameterSpec = null;
            Object object2 = this.AFInAppEventType;
            synchronized (object2) {
                if (!this.values.containsAlias((String)object)) {
                    if (Build.VERSION.SDK_INT >= 23) {
                        keyGenParameterSpec = new KeyGenParameterSpec.Builder((String)object, 3).setCertificateSubject(new X500Principal("CN=AndroidSDK, O=AppsFlyer")).setCertificateSerialNumber(BigInteger.ONE).setCertificateNotBefore(calendar.getTime()).setCertificateNotAfter(calendar2.getTime()).build();
                    } else if (Build.VERSION.SDK_INT >= 18 && !aa.AFInAppEventParameterName()) {
                        keyGenParameterSpec = new KeyPairGeneratorSpec.Builder(this.AFKeystoreWrapper).setAlias((String)object).setSubject(new X500Principal("CN=AndroidSDK, O=AppsFlyer")).setSerialNumber(BigInteger.ONE).setStartDate(calendar.getTime()).setEndDate(calendar2.getTime()).build();
                    }
                    object = KeyPairGenerator.getInstance("RSA", "AndroidKeyStore");
                    ((KeyPairGenerator)object).initialize((AlgorithmParameterSpec)keyGenParameterSpec);
                    ((KeyPairGeneratorSpi)object).generateKeyPair();
                } else {
                    AFLogger.AFKeystoreWrapper("Alias already exists: ".concat(String.valueOf(object)));
                }
                return;
            }
        }
        catch (Throwable throwable) {
            AFLogger.AFInAppEventParameterName("Exception " + throwable.getMessage() + " occurred", throwable);
            return;
        }
    }

    private static boolean AFInAppEventType(String string) {
        return string.startsWith("com.appsflyer");
    }

    public final String values() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("com.appsflyer,");
        Object object = this.AFInAppEventType;
        synchronized (object) {
            stringBuilder.append("KSAppsFlyerId=").append(this.AFInAppEventParameterName).append(",");
            stringBuilder.append("KSAppsFlyerRICounter=").append(this.valueOf);
        }
        return ((Object)stringBuilder).toString();
    }

    public final String AFInAppEventParameterName() {
        Object object = this.AFInAppEventType;
        synchronized (object) {
            return this.AFInAppEventParameterName;
        }
    }

    public final int AFKeystoreWrapper() {
        Object object = this.AFInAppEventType;
        synchronized (object) {
            return this.valueOf;
        }
    }
}

