/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Build;
import android.os.Process;
import com.appsflyer.AFDateFormat;
import com.appsflyer.AFLogger;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;

public class AndroidUtils {
    public static boolean isServiceAvailable(Context context, Intent intent) {
        return context.getPackageManager().queryIntentServices(intent, 0).size() > 0;
    }

    public static boolean isPermissionAvailable(Context context, String string) {
        if (string == null) {
            throw new IllegalArgumentException("permission is null");
        }
        int n = context.checkPermission(string, Process.myPid(), Process.myUid());
        AFLogger.afRDLog("is Permission Available: " + string + "; res: " + n);
        return n == 0;
    }

    static boolean $$a() {
        return Build.BRAND.equals("OPPO");
    }

    static Map<String, String> valueOf(Context context, Map<String, String> map, Uri uri) {
        String string = "agency";
        for (String string2 : uri.getQueryParameterNames()) {
            String string3 = uri.getQueryParameter(string2);
            if (!map.containsKey(string2)) {
                switch (string2) {
                    case "c": {
                        string2 = "campaign";
                        break;
                    }
                    case "pid": {
                        string2 = "media_source";
                        break;
                    }
                    case "af_prt": {
                        string2 = string;
                    }
                }
            }
            map.put(string2, string3);
        }
        try {
            if (!map.containsKey("install_time")) {
                map.put("install_time", AFDateFormat.dateFormatUTC(AFDateFormat.getDataFormatter("yyyy-MM-dd HH:mm:ss"), context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).firstInstallTime));
            }
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("Could not fetch install time. ", exception);
        }
        if (map.containsKey("af_deeplink") && !map.containsKey("af_status")) {
            map.put("af_status", "Non-organic");
        }
        if (map.containsKey(string)) {
            map.remove("media_source");
        }
        String string4 = uri.getPath();
        String string5 = "path";
        Map<String, String> map2 = map;
        if (string4 != null) {
            map2.put(string5, string4);
        }
        string4 = uri.getScheme();
        string5 = "scheme";
        map2 = map;
        if (string4 != null) {
            map2.put(string5, string4);
        }
        string4 = uri.getHost();
        string5 = "host";
        map2 = map;
        if (string4 != null) {
            map2.put(string5, string4);
        }
        return map;
    }

    public static String signature(PackageManager packageManager, String string) throws PackageManager.NameNotFoundException, CertificateException, NoSuchAlgorithmException {
        Signature[] signatureArray = packageManager.getPackageInfo((String)string, (int)64).signatures;
        if (packageManager.getPackageInfo((String)string, (int)64).signatures == null) {
            return null;
        }
        X509Certificate x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(signatureArray[0].toByteArray()));
        MessageDigest messageDigest = MessageDigest.getInstance("SHA256");
        messageDigest.update(x509Certificate.getEncoded());
        return String.format("%032X", new BigInteger(1, messageDigest.digest()));
    }

    public static long getVersionCode(Context context, String string) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(string, 0);
            if (Build.VERSION.SDK_INT >= 28) {
                return packageInfo.getLongVersionCode();
            }
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            PackageManager.NameNotFoundException nameNotFoundException2 = nameNotFoundException;
            AFLogger.afErrorLog(nameNotFoundException.getMessage(), nameNotFoundException2);
            return 0L;
        }
    }

    public static String getVersionName(Context context, String string) {
        try {
            return context.getPackageManager().getPackageInfo((String)string, (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            PackageManager.NameNotFoundException nameNotFoundException2 = nameNotFoundException;
            AFLogger.afErrorLog(nameNotFoundException.getMessage(), nameNotFoundException2);
            return "";
        }
    }
}

