/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import com.appsflyer.internal.AFh1bSDK;
import com.appsflyer.internal.AFh1dSDK;
import com.appsflyer.internal.AFi1uSDK;
import java.util.ArrayList;
import java.util.List;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public final class AFi1zSDK {
    @Nullable
    public final AFh1bSDK getCurrencyIso4217Code;
    @Nullable
    public final AFh1dSDK getMediationNetwork;
    @Nullable
    public AFi1uSDK AFAdRevenueData;

    public AFi1zSDK(@NotNull JSONObject jSONObject) {
        Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"");
        this.AFAdRevenueData = AFi1zSDK.getMediationNetwork(jSONObject);
        this.getCurrencyIso4217Code = AFi1zSDK.getRevenue(jSONObject);
        this.getMediationNetwork = AFi1zSDK.getMonetizationNetwork(jSONObject);
    }

    private static AFh1dSDK getMonetizationNetwork(JSONObject object) {
        try {
            AFh1dSDK aFh1dSDK;
            JSONObject jSONObject = AFi1zSDK.AFAdRevenueData((JSONObject)object, "meta_data");
            if (jSONObject != null) {
                double d = jSONObject.optDouble("send_rate", 1.0);
                aFh1dSDK = new AFh1dSDK(d);
            } else {
                aFh1dSDK = null;
            }
            object = Result.constructor-impl(aFh1dSDK);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (AFh1dSDK)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static AFh1bSDK getRevenue(JSONObject object) {
        try {
            AFh1bSDK aFh1bSDK;
            JSONObject jSONObject = AFi1zSDK.AFAdRevenueData((JSONObject)object, "exc_mngr");
            if (jSONObject != null) {
                object = jSONObject;
                String string = jSONObject.getString("sdk_ver");
                int n = object.optInt("min", -1);
                int n2 = object.optInt("expire", -1);
                long l = object.optLong("ttl", -1L);
                aFh1bSDK = new AFh1bSDK(string, n, n2, l);
            } else {
                aFh1bSDK = null;
            }
            object = Result.constructor-impl(aFh1bSDK);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (AFh1bSDK)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static AFi1uSDK getMediationNetwork(JSONObject object) {
        try {
            AFi1uSDK aFi1uSDK;
            JSONObject jSONObject = AFi1zSDK.AFAdRevenueData(object, "r_debugger");
            if (jSONObject != null) {
                List list;
                object = jSONObject;
                long l = jSONObject.getLong("ttl");
                int n = object.getInt("counter");
                String string = object.optString("app_ver", "");
                String string2 = object.optString("sdk_ver", "");
                float f = (float)object.optDouble("ratio", 1.0);
                if ((object = object.optJSONArray("tags")) != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
                    List list2 = new ArrayList();
                    int n2 = object.length();
                    for (int i = 0; i < n2; ++i) {
                        String string3 = object.getString(i);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
                        list2.add(string3);
                    }
                    list = list2;
                } else {
                    list = CollectionsKt.emptyList();
                }
                object = list;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                aFi1uSDK = new AFi1uSDK(l, f, (List<String>)object, n, string, string2);
            } else {
                aFi1uSDK = null;
            }
            object = Result.constructor-impl(aFi1uSDK);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (AFi1uSDK)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static JSONObject AFAdRevenueData(JSONObject jSONObject, String string) throws JSONException, NullPointerException {
        if (jSONObject.has(string)) {
            if ((jSONObject = jSONObject.getJSONArray(string).optJSONObject(0).optJSONObject("data")) != null) {
                return jSONObject.optJSONObject("v1");
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(@Nullable Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"");
        AFi1zSDK cfr_ignored_0 = (AFi1zSDK)other;
        if (!Intrinsics.areEqual((Object)this.getCurrencyIso4217Code, (Object)((AFi1zSDK)other).getCurrencyIso4217Code)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getMediationNetwork, (Object)((AFi1zSDK)other).getMediationNetwork)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.AFAdRevenueData, (Object)((AFi1zSDK)var1_1).AFAdRevenueData);
    }

    public final int hashCode() {
        AFh1bSDK aFh1bSDK = this.getCurrencyIso4217Code;
        int n = aFh1bSDK != null ? ((Object)aFh1bSDK).hashCode() : 0;
        AFh1dSDK aFh1dSDK = this.getMediationNetwork;
        n = n * 31 + (aFh1dSDK != null ? aFh1dSDK.hashCode() : 0);
        AFi1uSDK aFi1uSDK = this.AFAdRevenueData;
        return n * 31 + (aFi1uSDK != null ? ((Object)aFi1uSDK).hashCode() : 0);
    }
}

