/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFh1cSDK;
import com.appsflyer.internal.AFi1zSDK;
import org.json.JSONException;
import org.json.JSONObject;

public final class AFi1wSDK {
    private final boolean getMonetizationNetwork;
    @NonNull
    public final String getRevenue;
    @NonNull
    public final String AFAdRevenueData;
    @NonNull
    public final AFh1cSDK getMediationNetwork;
    @Nullable
    public final AFi1zSDK getCurrencyIso4217Code;

    public AFi1wSDK(@NonNull String object) throws JSONException {
        if (object == null) {
            throw new JSONException("Failed to parse remote configuration JSON: originalJson is null");
        }
        try {
            JSONObject jSONObject = new JSONObject((String)object);
            this.getRevenue = jSONObject.getString("ver");
            this.getMonetizationNetwork = jSONObject.optBoolean("test_mode");
            this.AFAdRevenueData = object;
            this.getMediationNetwork = this.getRevenue.startsWith("default") ? AFh1cSDK.AFAdRevenueData : AFh1cSDK.getMonetizationNetwork;
            object = null;
            jSONObject = jSONObject.optJSONObject("features");
            if (jSONObject != null) {
                object = new AFi1zSDK(jSONObject);
            }
            this.getCurrencyIso4217Code = object;
            return;
        }
        catch (JSONException jSONException) {
            AFLogger.afErrorLogForExcManagerOnly("Error in RC config parsing", jSONException);
            throw new JSONException("Failed to parse remote configuration JSON");
        }
    }

    public final boolean equals(Object o) {
        AFi1wSDK aFi1wSDK;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        aFi1wSDK = aFi1wSDK;
        if (this.getMonetizationNetwork != aFi1wSDK.getMonetizationNetwork) {
            return false;
        }
        if (!this.getRevenue.equals(aFi1wSDK.getRevenue)) {
            return false;
        }
        return this.AFAdRevenueData.equals(aFi1wSDK.AFAdRevenueData);
    }

    public final int hashCode() {
        int n = this.getMonetizationNetwork ? 1 : 0;
        n = n * 31 + this.getRevenue.hashCode();
        n = n * 31 + this.AFAdRevenueData.hashCode();
        if (this.getCurrencyIso4217Code != null) {
            n = n * 31 + ((Object)this.getCurrencyIso4217Code).hashCode();
        }
        return n;
    }
}

