/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFc1qSDK;
import com.appsflyer.internal.AFg1cSDK;
import com.appsflyer.internal.AFi1aSDK;
import com.appsflyer.internal.AFj1kSDK;
import com.appsflyer.internal.AFj1tSDK;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;

public class AFi1dSDK
extends AFi1aSDK {
    public final Map<String, Object> getRevenue = new HashMap<String, Object>();
    @NonNull
    final ExecutorService getMediationNetwork;

    public AFi1dSDK(@NonNull Runnable runnable, @NonNull ExecutorService executorService, @NonNull AFc1qSDK aFc1qSDK) {
        super("store", "google", aFc1qSDK, runnable);
        this.getMediationNetwork = executorService;
    }

    private boolean AFAdRevenueData(@NonNull Context context) {
        if (!this.getMediationNetwork()) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFj1kSDK.getMediationNetwork(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                AFLogger.INSTANCE.d(AFg1cSDK.copydefault, "Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            AFLogger.INSTANCE.v(AFg1cSDK.copydefault, "Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            AFLogger.INSTANCE.e(AFg1cSDK.copydefault, "An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        AFLogger.INSTANCE.d(AFg1cSDK.copydefault, "Install referrer is not allowed");
        return false;
    }

    @Override
    public final void getRevenue(Context context) {
        if (!this.AFAdRevenueData(context)) {
            return;
        }
        AFi1dSDK aFi1dSDK = this;
        this.areAllFieldsValid = System.currentTimeMillis();
        aFi1dSDK.component4 = AFj1tSDK.AFa1uSDK.AFAdRevenueData;
        aFi1dSDK.addObserver(new Observer(aFi1dSDK){
            private /* synthetic */ AFj1tSDK AFAdRevenueData;
            {
                this.AFAdRevenueData = aFj1tSDK;
            }

            public final void update(Observable o, Object arg) {
                this.AFAdRevenueData.getMonetizationNetwork.run();
            }
        });
        try {
            aFi1dSDK = InstallReferrerClient.newBuilder((Context)context).build();
            AFLogger.INSTANCE.d(AFg1cSDK.copydefault, "Connecting to Install Referrer Library...");
            aFi1dSDK.startConnection(new InstallReferrerStateListener(){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                final /* synthetic */ Context val$context;
                {
                    this.val$referrerClient = installReferrerClient;
                    this.val$context = context;
                }

                public final void onInstallReferrerSetupFinished(int responseCode) {
                    AFi1dSDK.this.getMediationNetwork.execute(() -> AFi1dSDK.this.getCurrencyIso4217Code(this.val$referrerClient, this.val$context, responseCode));
                }

                public final void onInstallReferrerServiceDisconnected() {
                    AFLogger.INSTANCE.d(AFg1cSDK.copydefault, "Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            AFLogger.INSTANCE.e(AFg1cSDK.copydefault, "referrerClient -> startConnection", throwable);
            return;
        }
    }

    @WorkerThread
    @VisibleForTesting
    protected final void getCurrencyIso4217Code(InstallReferrerClient installReferrerClient, Context referrerDetails, int n) {
        this.getRevenue.put("code", String.valueOf(n));
        String string = "com.android.vending";
        referrerDetails = AFj1kSDK.AFAdRevenueData((Context)referrerDetails, string);
        this.getCurrencyIso4217Code.put("api_ver", referrerDetails.getFirst());
        this.getCurrencyIso4217Code.put("api_ver_name", referrerDetails.getSecond());
        switch (n) {
            case 0: {
                this.getCurrencyIso4217Code.put("response", "OK");
                try {
                    AFLogger.INSTANCE.d(AFg1cSDK.copydefault, "InstallReferrer connected");
                    if (installReferrerClient.isReady()) {
                        referrerDetails = installReferrerClient.getInstallReferrer();
                        Object object = referrerDetails.getInstallReferrer();
                        if (object != null) {
                            this.getRevenue.put("val", object);
                            this.getCurrencyIso4217Code.put("referrer", object);
                        }
                        long l = referrerDetails.getReferrerClickTimestampSeconds();
                        this.getRevenue.put("clk", Long.toString(l));
                        this.getCurrencyIso4217Code.put("click_ts", l);
                        long l2 = referrerDetails.getInstallBeginTimestampSeconds();
                        this.getRevenue.put("install", Long.toString(l2));
                        this.getCurrencyIso4217Code.put("install_begin_ts", l2);
                        object = new HashMap();
                        try {
                            boolean bl = referrerDetails.getGooglePlayInstantParam();
                            this.getRevenue.put("instant", bl);
                            ((AbstractMap)object).put("instant", bl);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                        }
                        try {
                            ((AbstractMap)object).put("click_server_ts", referrerDetails.getReferrerClickTimestampServerSeconds());
                            ((AbstractMap)object).put("install_begin_server_ts", referrerDetails.getInstallBeginTimestampServerSeconds());
                            ((AbstractMap)object).put("install_version", referrerDetails.getInstallVersion());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.INSTANCE.e(AFg1cSDK.copydefault, "some method not exist", noSuchMethodError, false, false);
                        }
                        if (!((AbstractMap)object).isEmpty()) {
                            this.getCurrencyIso4217Code.put("google_custom", object);
                        }
                        installReferrerClient.endConnection();
                        break;
                    }
                    AFLogger.INSTANCE.w(AFg1cSDK.copydefault, "ReferrerClient: InstallReferrer is not ready");
                    this.getRevenue.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
                catch (Throwable throwable) {
                    AFLogger.INSTANCE.w(AFg1cSDK.copydefault, "Failed to get install referrer: " + throwable.getMessage());
                    this.getRevenue.put("err", throwable.getMessage());
                    AFLogger.INSTANCE.e(AFg1cSDK.copydefault, "Failed to get install referrer", throwable, false, false);
                }
                break;
            }
            case 2: {
                AFLogger.INSTANCE.w(AFg1cSDK.copydefault, "InstallReferrer FEATURE_NOT_SUPPORTED");
                this.getCurrencyIso4217Code.put("response", "FEATURE_NOT_SUPPORTED");
                break;
            }
            case 1: {
                this.getCurrencyIso4217Code.put("response", "SERVICE_UNAVAILABLE");
                AFLogger.INSTANCE.w(AFg1cSDK.copydefault, "InstallReferrer not supported");
                break;
            }
            case 3: {
                AFLogger.INSTANCE.w(AFg1cSDK.copydefault, "InstallReferrer DEVELOPER_ERROR");
                this.getCurrencyIso4217Code.put("response", "DEVELOPER_ERROR");
                break;
            }
            case -1: {
                AFLogger.INSTANCE.w(AFg1cSDK.copydefault, "InstallReferrer SERVICE_DISCONNECTED");
                this.getCurrencyIso4217Code.put("response", "SERVICE_DISCONNECTED");
                break;
            }
            default: {
                AFLogger.INSTANCE.w(AFg1cSDK.copydefault, "responseCode not found.");
            }
        }
        AFLogger.INSTANCE.d(AFg1cSDK.copydefault, "Install Referrer collected locally");
        this.getRevenue();
    }
}

