/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import androidx.annotation.WorkerThread;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFg1gSDK;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public final class AFf1kSDK {
    private static AFf1kSDK getMediationNetwork = null;
    private final Map<String, String> getMonetizationNetwork = new HashMap<String, String>(this){
        private /* synthetic */ AFf1kSDK getRevenue;
        {
            this.getRevenue = aFf1kSDK;
            ((AbstractMap)this).put("aa", "ro.arch");
            ((AbstractMap)this).put("ab", "ro.chipname");
            ((AbstractMap)this).put("ac", "ro.dalvik.vm.native.bridge");
            ((AbstractMap)this).put("ad", "persist.sys.nativebridge");
            ((AbstractMap)this).put("ae", "ro.enable.native.bridge.exec");
            ((AbstractMap)this).put("af", "dalvik.vm.isa.x86.features");
            ((AbstractMap)this).put("ag", "dalvik.vm.isa.x86.variant");
            ((AbstractMap)this).put("ah", "ro.zygote");
            ((AbstractMap)this).put("ai", "ro.allow.mock.location");
            ((AbstractMap)this).put("aj", "ro.dalvik.vm.isa.arm");
            ((AbstractMap)this).put("ak", "dalvik.vm.isa.arm.features");
            ((AbstractMap)this).put("al", "dalvik.vm.isa.arm.variant");
            ((AbstractMap)this).put("am", "dalvik.vm.isa.arm64.features");
            ((AbstractMap)this).put("an", "dalvik.vm.isa.arm64.variant");
            ((AbstractMap)this).put("ao", "vzw.os.rooted");
            ((AbstractMap)this).put("ap", "ro.build.user");
            ((AbstractMap)this).put("aq", "ro.kernel.qemu");
            ((AbstractMap)this).put("ar", "ro.hardware");
            ((AbstractMap)this).put("as", "ro.product.cpu.abi");
            ((AbstractMap)this).put("at", "ro.product.cpu.abilist");
            ((AbstractMap)this).put("au", "ro.product.cpu.abilist32");
            ((AbstractMap)this).put("av", "ro.product.cpu.abilist64");
        }
    };

    private AFf1kSDK() {
    }

    @WorkerThread
    public static AFf1kSDK getMediationNetwork() {
        if (getMediationNetwork == null) {
            getMediationNetwork = new AFf1kSDK();
        }
        return getMediationNetwork;
    }

    public final Object getMonetizationNetwork(Context context, String object) {
        Object object2 = null;
        try {
            if (object == null || !AFf1kSDK.getMediationNetwork((String)object)) {
                object2 = "invalid timestamp";
            }
            object = new AFg1gSDK();
            ((AFg1gSDK)object).getCurrencyIso4217Code("pr", this.getRevenue());
            ((AFg1gSDK)object).getCurrencyIso4217Code("an", this.getMonetizationNetwork(context));
            object2 = object;
        }
        catch (Exception exception) {
            AFLogger.afErrorLogForExcManagerOnly("could not get anti fraud data", exception);
        }
        return object2;
    }

    private static boolean getMediationNetwork(String string) {
        return string.matches("\\d+");
    }

    private static boolean getMediationNetwork(Context context) {
        return 0 != (context.getApplicationInfo().flags & 2);
    }

    private static String getCurrencyIso4217Code() {
        int n = 0;
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Iterator<Map.Entry<Thread, StackTraceElement[]>> iterator = Thread.getAllStackTraces().entrySet().iterator();
            while (iterator.hasNext()) {
                for (StackTraceElement stackTraceElement : iterator.next().getValue()) {
                    if (((Object)stackTraceElement).toString().contains("de.robv.android.xposed") && n2 <= 2) {
                        ++n2;
                        stringBuilder.append(AFa1vSDK.AFAdRevenueData.getMediationNetwork);
                        if (stackTraceElement.getMethodName().equals("main")) {
                            stringBuilder.append("+a");
                        }
                        if (stackTraceElement.getMethodName().equals("handleHookedMethod")) {
                            stringBuilder.append("+h");
                        }
                        stringBuilder.append(";");
                    }
                    if (!stackTraceElement.getClassName().equals("com.android.internal.os.ZygoteInit")) continue;
                    ++n;
                }
            }
            if (n > 1) {
                stringBuilder.append("mz;");
            }
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLogForExcManagerOnly("hooking check error", throwable);
        }
        try {
            if (AFf1kSDK.AFAdRevenueData("/proc/" + Process.myPid() + "/maps", "frida")) {
                stringBuilder.append(AFa1vSDK.getCurrencyIso4217Code.getMediationNetwork);
                if (Build.VERSION.SDK_INT < 29 && AFf1kSDK.AFAdRevenueData("/proc/net/tcp", "69A2")) {
                    stringBuilder.append("+prt");
                }
            }
        }
        catch (Exception exception) {
            AFLogger.afErrorLogForExcManagerOnly("frida detection error", exception);
            stringBuilder.append(exception.getMessage().toLowerCase(Locale.getDefault()));
        }
        stringBuilder.append(";");
        return ((Object)stringBuilder).toString();
    }

    private AFg1gSDK getMonetizationNetwork(Context context) {
        AFg1gSDK aFg1gSDK = new AFg1gSDK();
        try {
            aFg1gSDK.getCurrencyIso4217Code(AFa1ySDK.getCurrencyIso4217Code.getMonetizationNetwork, AFf1kSDK.getCurrencyIso4217Code());
            aFg1gSDK.getCurrencyIso4217Code(AFa1ySDK.AFAdRevenueData.getMonetizationNetwork, AFf1kSDK.getMediationNetwork(context));
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLogForExcManagerOnly("failed to perform analysis checks", throwable);
        }
        return aFg1gSDK;
    }

    private AFg1gSDK getRevenue() {
        AFg1gSDK aFg1gSDK = new AFg1gSDK();
        try {
            for (Map.Entry<String, String> entry : this.getMonetizationNetwork.entrySet()) {
                String string = AFf1kSDK.getRevenue(entry.getValue());
                if (string == null || string.equals("")) continue;
                aFg1gSDK.getCurrencyIso4217Code(entry.getKey(), string);
            }
        }
        catch (Exception exception) {
            AFLogger.afErrorLogForExcManagerOnly("failed to create props", exception);
        }
        return aFg1gSDK;
    }

    @SuppressLint(value={"PrivateApi"})
    private static String getRevenue(String string) {
        String string2 = null;
        try {
            string2 = (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class).invoke(null, string);
        }
        catch (Exception exception) {
            AFLogger.afErrorLogForExcManagerOnly("error in props rfl", exception);
        }
        return string2;
    }

    private static boolean AFAdRevenueData(String object, String string) throws Exception {
        object = new File((String)object);
        try {
            String string2;
            object = new FileInputStream((File)object);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object, Charset.defaultCharset()));
            string = string.toLowerCase(Locale.getDefault());
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!new HashSet<String>(Arrays.asList(string2.toLowerCase(Locale.getDefault()).split("[\\s.,\\]\\-:/_\\[]"))).contains(string)) continue;
                ((Reader)bufferedReader).close();
                ((InputStream)object).close();
                return true;
            }
            ((Reader)bufferedReader).close();
            ((InputStream)object).close();
            return false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            AFLogger.afErrorLogForExcManagerOnly("FNF", fileNotFoundException);
            throw new Exception("FNF");
        }
        catch (IOException iOException) {
            AFLogger.afErrorLogForExcManagerOnly("IOF", iOException);
            throw new Exception("IOF");
        }
        catch (Exception exception) {
            AFLogger.afErrorLogForExcManagerOnly("GF", exception);
            throw new Exception("GF");
        }
    }

    static enum AFa1vSDK {
        AFAdRevenueData("xps"),
        getCurrencyIso4217Code("frd");

        String getMediationNetwork;

        private AFa1vSDK(String string2) {
            this.getMediationNetwork = string2;
        }
    }

    static enum AFa1ySDK {
        getCurrencyIso4217Code("hk"),
        AFAdRevenueData("dbg");

        String getMonetizationNetwork;

        private AFa1ySDK(String string2) {
            this.getMonetizationNetwork = string2;
        }
    }
}

